/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.process.persistence;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.GeneratedFile;
import org.kie.kogito.codegen.GeneratorContext;
import org.kie.kogito.codegen.context.KogitoBuildContext;
import org.kie.kogito.codegen.context.QuarkusKogitoBuildContext;
import org.kie.kogito.codegen.data.Person;
import org.kie.kogito.codegen.di.CDIDependencyInjectionAnnotator;
import org.kie.kogito.codegen.di.DependencyInjectionAnnotator;
import org.kie.kogito.codegen.process.persistence.PersistenceGenerator;

class MongoDBPersistenceGeneratorTest {
    private static final String TEST_RESOURCES = "src/test/resources";
    GeneratorContext context = GeneratorContext.ofResourcePath((File[])new File[]{new File("src/test/resources")});
    final Path targetDirectory = Paths.get("target", new String[0]);

    MongoDBPersistenceGeneratorTest() {
    }

    @Test
    void test() {
        this.context.withBuildContext((KogitoBuildContext)new QuarkusKogitoBuildContext(className -> true));
        PersistenceGenerator persistenceGenerator = new PersistenceGenerator(this.targetDirectory.toFile(), Collections.singleton(Person.class), true, null, null, Arrays.asList("com.mongodb.client.MongoClient"), "mongodb");
        persistenceGenerator.setPackageName(this.getClass().getPackage().getName());
        persistenceGenerator.setDependencyInjection(null);
        persistenceGenerator.setContext(this.context);
        persistenceGenerator.setDependencyInjection((DependencyInjectionAnnotator)new CDIDependencyInjectionAnnotator());
        Collection generatedFiles = persistenceGenerator.generate();
        Optional<GeneratedFile> generatedCLASSFile = generatedFiles.stream().filter(gf -> gf.getType() == GeneratedFile.Type.CLASS).findFirst();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)generatedCLASSFile.isPresent());
        GeneratedFile classFile = generatedCLASSFile.get();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"org/kie/kogito/persistence/KogitoProcessInstancesFactoryImpl.java", (Object)classFile.relativePath());
        CompilationUnit compilationUnit = StaticJavaParser.parse((InputStream)new ByteArrayInputStream(classFile.contents()));
        ClassOrInterfaceDeclaration classDeclaration = (ClassOrInterfaceDeclaration)compilationUnit.findFirst(ClassOrInterfaceDeclaration.class).orElseThrow(() -> new NoSuchElementException("Compilation unit doesn't contain a class or interface declaration!"));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)classDeclaration);
        MethodDeclaration methodDeclaration = (MethodDeclaration)classDeclaration.findFirst(MethodDeclaration.class, d -> d.getName().getIdentifier().equals("dbName")).orElseThrow(() -> new NoSuchElementException("Class declaration doesn't contain a method named \"dbName\"!"));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)methodDeclaration);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)methodDeclaration.getBody().isPresent());
        BlockStmt body = (BlockStmt)methodDeclaration.getBody().get();
        Assertions.assertThat((int)body.getStatements().size()).isOne();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Statement)body.getStatements().get(0)).isReturnStmt());
        ReturnStmt returnStmt = (ReturnStmt)body.getStatements().get(0);
        Assertions.assertThat((String)returnStmt.toString()).contains(new CharSequence[]{"kogito"});
    }
}

