/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.kie.kogito.Application;
import org.kie.kogito.codegen.ApplicationGenerator;
import org.kie.kogito.codegen.GeneratedFile;
import org.kie.kogito.codegen.Generator;
import org.kie.kogito.codegen.GeneratorContext;
import org.kie.kogito.codegen.context.JavaKogitoBuildContext;
import org.kie.kogito.codegen.context.KogitoBuildContext;
import org.kie.kogito.codegen.context.QuarkusKogitoBuildContext;
import org.kie.kogito.codegen.context.SpringBootKogitoBuildContext;
import org.kie.kogito.codegen.decision.DecisionCodegen;
import org.kie.kogito.codegen.io.CollectedResource;
import org.kie.kogito.codegen.prediction.PredictionCodegen;
import org.kie.kogito.codegen.process.ProcessCodegen;
import org.kie.kogito.codegen.rules.IncrementalRuleCodegen;
import org.kie.memorycompiler.CompilationResult;
import org.kie.memorycompiler.JavaCompiler;
import org.kie.memorycompiler.JavaCompilerFactory;
import org.kie.memorycompiler.JavaConfiguration;
import org.kie.memorycompiler.resources.ResourceReader;
import org.kie.memorycompiler.resources.ResourceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractCodegenTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCodegenTest.class);
    private TestClassLoader classloader;
    private static final JavaCompiler JAVA_COMPILER = JavaCompilerFactory.loadCompiler((JavaConfiguration.CompilerType)JavaConfiguration.CompilerType.NATIVE, (String)"11");
    private static final String TEST_JAVA = "src/test/java/";
    private static final String TEST_RESOURCES = "src/test/resources";
    private static final Map<TYPE, Function<List<String>, Generator>> generatorTypeMap = new HashMap<TYPE, Function<List<String>, Generator>>();
    private KogitoBuildContext buildContext = new JavaKogitoBuildContext(this.getClass().getClassLoader());
    private static final String DUMMY_PROCESS_RUNTIME = "package org.drools.project.model;\n\nimport org.kie.api.KieBase;\nimport org.kie.api.builder.model.KieBaseModel;\nimport org.kie.api.runtime.KieSession;\nimport org.drools.modelcompiler.builder.KieBaseBuilder;\n\n\npublic class ProjectRuntime implements org.kie.kogito.rules.KieRuntimeBuilder {\n\n    public static final ProjectRuntime INSTANCE = new ProjectRuntime();\n\n    @Override\n    public KieBase getKieBase() {\n        return null;\n    }\n\n    @Override\n    public KieBase getKieBase(String name) {\n        return null;\n    }\n\n    @Override\n    public KieSession newKieSession() {\n        return null;\n    }\n\n    @Override\n    public KieSession newKieSession(String sessionName) {\n        return null;\n    }\n\n    @Override\n    public KieSession newKieSession(String sessionName, org.kie.kogito.rules.RuleConfig ruleConfig) {\n        return null;\n    }\n\n}";

    private static Collection<CollectedResource> toCollectedResources(String basePath, List<String> strings) {
        File[] files = (File[])strings.stream().map(resource -> new File(basePath, (String)resource)).toArray(File[]::new);
        return CollectedResource.fromFiles((Path)Paths.get(basePath, new String[0]), (File[])files);
    }

    private static List<File> toFiles(List<String> strings, String path) {
        return strings.stream().map(resource -> new File(path, (String)resource)).collect(Collectors.toList());
    }

    public void withSpringContext() {
        this.buildContext = new SpringBootKogitoBuildContext(className -> true);
        throw new UnsupportedOperationException("To be fixed KOGITO-4000");
    }

    public void withQuarkusContext() {
        this.buildContext = new QuarkusKogitoBuildContext(className -> true);
        throw new UnsupportedOperationException("To be fixed KOGITO-4000");
    }

    public void withJavaContext() {
        this.buildContext = new JavaKogitoBuildContext(className -> true);
        throw new UnsupportedOperationException("To be fixed KOGITO-4000");
    }

    protected Application generateCodeProcessesOnly(String ... processes) throws Exception {
        HashMap<TYPE, List<String>> resourcesTypeMap = new HashMap<TYPE, List<String>>();
        resourcesTypeMap.put(TYPE.PROCESS, Arrays.asList(processes));
        return this.generateCode(resourcesTypeMap);
    }

    protected Application generateCodeRulesOnly(String ... rules) throws Exception {
        HashMap<TYPE, List<String>> resourcesTypeMap = new HashMap<TYPE, List<String>>();
        resourcesTypeMap.put(TYPE.RULES, Arrays.asList(rules));
        return this.generateCode(resourcesTypeMap);
    }

    protected Application generateRulesFromJava(String ... javaSourceCode) throws Exception {
        HashMap<TYPE, List<String>> resourcesTypeMap = new HashMap<TYPE, List<String>>();
        resourcesTypeMap.put(TYPE.JAVA, Arrays.asList(javaSourceCode));
        return this.generateCode(resourcesTypeMap);
    }

    protected Application generateCode(Map<TYPE, List<String>> resourcesTypeMap) throws Exception {
        return this.generateCode(resourcesTypeMap, this.getClass().getPackage().getName());
    }

    protected Application generateCode(Map<TYPE, List<String>> resourcesTypeMap, String packageName) throws Exception {
        GeneratorContext context = GeneratorContext.ofResourcePath((File[])new File[]{new File(TEST_RESOURCES)});
        context.withBuildContext(this.buildContext);
        ApplicationGenerator appGen = new ApplicationGenerator(context, packageName, new File("target/codegen-tests"));
        HashSet<TYPE> generatedTypes = new HashSet<TYPE>();
        for (TYPE type : TYPE.values()) {
            if (!resourcesTypeMap.containsKey((Object)type) || resourcesTypeMap.get((Object)type).isEmpty()) continue;
            appGen.setupGenerator(generatorTypeMap.get((Object)type).apply(resourcesTypeMap.get((Object)type)));
            generatedTypes.add(type);
        }
        if (generatedTypes.contains((Object)TYPE.DECISION) && !generatedTypes.contains((Object)TYPE.PREDICTION)) {
            appGen.setupGenerator(generatorTypeMap.get((Object)TYPE.PREDICTION).apply(Collections.emptyList()));
        }
        Collection generatedFiles = appGen.generate();
        MemoryFileSystem srcMfs = new MemoryFileSystem();
        MemoryFileSystem trgMfs = new MemoryFileSystem();
        ArrayList<String> sources = new ArrayList<String>();
        for (Object entry : generatedFiles) {
            String fileName = entry.relativePath();
            if (!fileName.endsWith(".java")) continue;
            sources.add(fileName);
            srcMfs.write(fileName, entry.contents());
            this.log(new String(entry.contents()));
        }
        if (resourcesTypeMap.size() == 1 && resourcesTypeMap.containsKey((Object)TYPE.PROCESS)) {
            sources.add("org/drools/project/model/ProjectRuntime.java");
            srcMfs.write("org/drools/project/model/ProjectRuntime.java", DUMMY_PROCESS_RUNTIME.getBytes());
        }
        if (LOGGER.isDebugEnabled()) {
            Path temp = Files.createTempDirectory("KOGITO_TESTS", new FileAttribute[0]);
            LOGGER.debug("Dumping generated files in " + temp);
            for (GeneratedFile entry : generatedFiles) {
                Path fpath = temp.resolve(entry.relativePath());
                fpath.getParent().toFile().mkdirs();
                Files.write(fpath, entry.contents(), new OpenOption[0]);
            }
        }
        CompilationResult result = JAVA_COMPILER.compile(sources.toArray(new String[sources.size()]), (ResourceReader)srcMfs, (ResourceStore)trgMfs, this.getClass().getClassLoader());
        Assertions.assertThat((Object)result).isNotNull();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])result.getErrors()).describedAs(String.join((CharSequence)"\n\n", Arrays.toString(result.getErrors())), new Object[0])).hasSize(0);
        this.classloader = new TestClassLoader(this.getClass().getClassLoader(), trgMfs.getMap());
        Class<?> app = Class.forName(packageName + ".Application", true, this.classloader);
        Application application = (Application)app.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        return application;
    }

    protected ClassLoader testClassLoader() {
        return this.classloader;
    }

    protected void log(String content) {
        LOGGER.debug(content);
    }

    static {
        generatorTypeMap.put(TYPE.PROCESS, strings -> ProcessCodegen.ofCollectedResources(AbstractCodegenTest.toCollectedResources(TEST_RESOURCES, strings)));
        generatorTypeMap.put(TYPE.RULES, strings -> IncrementalRuleCodegen.ofCollectedResources(AbstractCodegenTest.toCollectedResources(TEST_RESOURCES, strings)));
        generatorTypeMap.put(TYPE.DECISION, strings -> DecisionCodegen.ofCollectedResources(AbstractCodegenTest.toCollectedResources(TEST_RESOURCES, strings)));
        generatorTypeMap.put(TYPE.JAVA, strings -> IncrementalRuleCodegen.ofJavaResources(AbstractCodegenTest.toCollectedResources(TEST_JAVA, strings)));
        generatorTypeMap.put(TYPE.PREDICTION, strings -> PredictionCodegen.ofCollectedResources((boolean)false, AbstractCodegenTest.toCollectedResources(TEST_RESOURCES, strings)));
    }

    private static class TestClassLoader
    extends URLClassLoader {
        private final Map<String, byte[]> extraClassDefs = new HashMap<String, byte[]>();

        public TestClassLoader(ClassLoader parent, Map<String, byte[]> extraClassDefs) {
            super(new URL[0], parent);
            for (Map.Entry<String, byte[]> entry : extraClassDefs.entrySet()) {
                this.extraClassDefs.put(entry.getKey().replaceAll("/", ".").replaceFirst("\\.class", ""), entry.getValue());
            }
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            byte[] classBytes = this.extraClassDefs.remove(name);
            if (classBytes != null) {
                return this.defineClass(name, classBytes, 0, classBytes.length);
            }
            return super.findClass(name);
        }
    }

    protected static enum TYPE {
        PROCESS,
        RULES,
        DECISION,
        JAVA,
        PREDICTION;

    }
}

