/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.AddonsConfig;

public class AddonsConfigTest {
    @Test
    public void allAddonsAreDisabledInDefaultConfiguration() {
        AddonsConfig addonsConfig = AddonsConfig.DEFAULT;
        Assertions.assertThat((boolean)addonsConfig.useMonitoring()).isFalse();
        Assertions.assertThat((boolean)addonsConfig.useTracing()).isFalse();
        Assertions.assertThat((boolean)addonsConfig.usePersistence()).isFalse();
    }

    @Test
    public void addonsAreProperlyActivated() {
        AddonsConfig addonsConfig = new AddonsConfig();
        Assertions.assertThat((boolean)addonsConfig.useMonitoring()).isFalse();
        Assertions.assertThat((boolean)addonsConfig.withMonitoring(true).useMonitoring()).isTrue();
        Assertions.assertThat((boolean)addonsConfig.usePrometheusMonitoring()).isFalse();
        Assertions.assertThat((boolean)addonsConfig.withPrometheusMonitoring(true).usePrometheusMonitoring()).isTrue();
        Assertions.assertThat((boolean)addonsConfig.useTracing()).isFalse();
        Assertions.assertThat((boolean)addonsConfig.withTracing(true).useTracing()).isTrue();
        Assertions.assertThat((boolean)addonsConfig.usePersistence()).isFalse();
        Assertions.assertThat((boolean)addonsConfig.withPersistence(true).usePersistence()).isTrue();
        Assertions.assertThat((boolean)addonsConfig.useKnativeEventing()).isFalse();
        Assertions.assertThat((boolean)addonsConfig.withKnativeEventing(true).useKnativeEventing()).isTrue();
        Assertions.assertThat((boolean)addonsConfig.useCloudEvents()).isFalse();
        Assertions.assertThat((boolean)addonsConfig.withCloudEvents(true).useCloudEvents()).isTrue();
    }
}

