/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.prediction;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.drools.core.util.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.dmn.feel.codegen.feel11.CodegenStringUtil;
import org.kie.kogito.codegen.context.JavaKogitoBuildContext;
import org.kie.kogito.codegen.context.KogitoBuildContext;
import org.kie.kogito.codegen.di.CDIDependencyInjectionAnnotator;
import org.kie.kogito.codegen.di.DependencyInjectionAnnotator;
import org.kie.kogito.codegen.prediction.PMMLRestResourceGenerator;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;

class PMMLRestResourceGeneratorTest {
    private static final String APP_CANONICAL_NAME = "APP_CANONICAL_NAME";
    private static final KiePMMLModel KIE_PMML_MODEL = PMMLRestResourceGeneratorTest.getKiePMMLModelInternal();
    private static PMMLRestResourceGenerator pmmlRestResourceGenerator;
    private static ClassOrInterfaceDeclaration template;
    private static KogitoBuildContext buildContext;

    PMMLRestResourceGeneratorTest() {
    }

    @BeforeAll
    public static void setup() {
        buildContext = new JavaKogitoBuildContext();
        pmmlRestResourceGenerator = new PMMLRestResourceGenerator(buildContext, KIE_PMML_MODEL, APP_CANONICAL_NAME);
        Assertions.assertNotNull((Object)pmmlRestResourceGenerator);
    }

    private static KiePMMLModel getKiePMMLModelInternal() {
        String modelName = "MODEL_NAME";
        return new KiePMMLModel(modelName, Collections.emptyList()){

            public Object evaluate(Object o, Map<String, Object> map) {
                return null;
            }
        };
    }

    private static ClassOrInterfaceDeclaration getClassOrInterfaceDeclaration() {
        CompilationUnit clazz = StaticJavaParser.parse((InputStream)PMMLRestResourceGeneratorTest.class.getResourceAsStream("/class-templates/PMMLRestResourceTemplate.java"));
        clazz.setPackageDeclaration(CodegenStringUtil.escapeIdentifier((String)"IDENTIFIER"));
        return (ClassOrInterfaceDeclaration)clazz.findFirst(ClassOrInterfaceDeclaration.class).orElseThrow(() -> new NoSuchElementException("Compilation unit doesn't contain a class or interface declaration!"));
    }

    @Test
    void constructor() {
        Assertions.assertTrue((boolean)PMMLRestResourceGeneratorTest.pmmlRestResourceGenerator.packageName.startsWith("org.kie.kogito"));
        Assertions.assertEquals((Object)APP_CANONICAL_NAME, (Object)PMMLRestResourceGeneratorTest.pmmlRestResourceGenerator.appCanonicalName);
    }

    @Test
    void generateWithDependencyInjection() {
        buildContext.setDependencyInjectionAnnotator((DependencyInjectionAnnotator)new CDIDependencyInjectionAnnotator());
        String retrieved = pmmlRestResourceGenerator.generate();
        this.commonEvaluateGenerate(retrieved);
        String expected = "Application application;";
        Assertions.assertTrue((boolean)retrieved.contains(expected));
    }

    @Test
    void generateWithoutDependencyInjection() {
        buildContext.setDependencyInjectionAnnotator(null);
        String retrieved = pmmlRestResourceGenerator.generate();
        this.commonEvaluateGenerate(retrieved);
        String expected = String.format("Application application = new %s();", APP_CANONICAL_NAME);
        Assertions.assertTrue((boolean)retrieved.contains(expected));
    }

    @Test
    void getNameURL() {
        String classPrefix = KiePMMLModelUtils.getSanitizedClassName((String)KIE_PMML_MODEL.getName());
        String expected = URLEncoder.encode(classPrefix).replaceAll("\\+", " ");
        Assertions.assertEquals((Object)expected, (Object)pmmlRestResourceGenerator.getNameURL());
    }

    @Test
    void getKiePMMLModel() {
        Assertions.assertEquals((Object)KIE_PMML_MODEL, (Object)pmmlRestResourceGenerator.getKiePMMLModel());
    }

    @Test
    void className() {
        String classPrefix = KiePMMLModelUtils.getSanitizedClassName((String)KIE_PMML_MODEL.getName());
        String expected = StringUtils.ucFirst((String)classPrefix) + "Resource";
        Assertions.assertEquals((Object)expected, (Object)pmmlRestResourceGenerator.className());
    }

    @Test
    void generatedFilePath() {
        String retrieved = pmmlRestResourceGenerator.generatedFilePath();
        Assertions.assertTrue((boolean)retrieved.startsWith("org/kie/kogito"));
        String classPrefix = KiePMMLModelUtils.getSanitizedClassName((String)KIE_PMML_MODEL.getName());
        String expected = StringUtils.ucFirst((String)classPrefix) + "Resource.java";
        Assertions.assertTrue((boolean)retrieved.endsWith(expected));
    }

    @Test
    void setPathValue() {
        Optional retrievedOpt = template.findFirst(SingleMemberAnnotationExpr.class);
        Assertions.assertTrue((boolean)retrievedOpt.isPresent());
        SingleMemberAnnotationExpr retrieved = (SingleMemberAnnotationExpr)retrievedOpt.get();
        Assertions.assertEquals((Object)"Path", (Object)retrieved.getName().asString());
        pmmlRestResourceGenerator.setPathValue(template);
        try {
            String classPrefix = KiePMMLModelUtils.getSanitizedClassName((String)KIE_PMML_MODEL.getName());
            String expected = URLEncoder.encode(classPrefix).replaceAll("\\+", " ");
            Assertions.assertEquals((Object)expected, (Object)retrieved.getMemberValue().asStringLiteralExpr().asString());
        }
        catch (Exception e) {
            Assertions.fail((Throwable)e);
        }
    }

    @Test
    void setPredictionModelName() {
        Assertions.assertEquals((int)1, (int)template.getMethodsByName("pmml").size());
        Optional retrievedOpt = ((MethodDeclaration)template.getMethodsByName("pmml").get(0)).getBody();
        Assertions.assertTrue((boolean)retrievedOpt.isPresent());
        BlockStmt retrieved = (BlockStmt)retrievedOpt.get();
        Assertions.assertTrue((boolean)(retrieved.getStatement(0) instanceof ExpressionStmt));
        Assertions.assertTrue((boolean)(retrieved.getStatement(0).asExpressionStmt().getExpression() instanceof VariableDeclarationExpr));
        VariableDeclarationExpr variableDeclarationExpr = retrieved.getStatement(0).asExpressionStmt().getExpression().asVariableDeclarationExpr();
        Optional expressionOpt = variableDeclarationExpr.getVariable(0).getInitializer();
        Assertions.assertTrue((boolean)expressionOpt.isPresent());
        Assertions.assertTrue((boolean)(expressionOpt.get() instanceof MethodCallExpr));
        MethodCallExpr methodCallExpr = ((Expression)expressionOpt.get()).asMethodCallExpr();
        Assertions.assertTrue((boolean)(methodCallExpr.getArgument(0) instanceof StringLiteralExpr));
        pmmlRestResourceGenerator.setPredictionModelName(template);
        try {
            Assertions.assertEquals((Object)KIE_PMML_MODEL.getName(), (Object)methodCallExpr.getArgument(0).asStringLiteralExpr().asString());
        }
        catch (Exception e) {
            Assertions.fail((Throwable)e);
        }
    }

    private void commonEvaluateGenerate(String retrieved) {
        Assertions.assertNotNull((Object)retrieved);
        String classPrefix = KiePMMLModelUtils.getSanitizedClassName((String)KIE_PMML_MODEL.getName());
        String expected = String.format("@Path(\"%s\")", classPrefix);
        Assertions.assertTrue((boolean)retrieved.contains(expected));
        expected = StringUtils.ucFirst((String)classPrefix) + "Resource";
        expected = String.format("public class %s {", expected);
        Assertions.assertTrue((boolean)retrieved.contains(expected));
        expected = String.format("org.kie.kogito.prediction.PredictionModel prediction = application.get(org.kie.kogito.prediction.PredictionModels.class).getPredictionModel(\"%s\");", KIE_PMML_MODEL.getName());
        Assertions.assertTrue((boolean)retrieved.contains(expected));
    }

    static {
        template = PMMLRestResourceGeneratorTest.getClassOrInterfaceDeclaration();
    }
}

