/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.prediction.config;

import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.GeneratedFile;
import org.kie.kogito.codegen.context.KogitoBuildContext;
import org.kie.kogito.codegen.context.QuarkusKogitoBuildContext;
import org.kie.kogito.codegen.context.SpringBootKogitoBuildContext;
import org.kie.kogito.codegen.prediction.config.PredictionConfigGenerator;

class PredictionConfigGeneratorTest {
    private static final String PACKAGE_NAME = "PACKAGENAME";

    PredictionConfigGeneratorTest() {
    }

    @Test
    void compilationUnitWithCDI() {
        PredictionConfigGenerator predictionConfigGenerator = new PredictionConfigGenerator((KogitoBuildContext)new QuarkusKogitoBuildContext(s -> false), PACKAGE_NAME);
        Optional retrievedOpt = predictionConfigGenerator.generate();
        Assertions.assertNotNull((Object)retrievedOpt);
        Assertions.assertTrue((boolean)retrievedOpt.isPresent());
        String retrieved = new String(((GeneratedFile)retrievedOpt.get()).contents());
        String expected = "@javax.inject.Singleton";
        Assertions.assertTrue((boolean)retrieved.contains(expected));
        expected = "@javax.inject.Inject";
        Assertions.assertTrue((boolean)retrieved.contains(expected));
        String unexpected = "@org.springframework.stereotype.Component";
        Assertions.assertFalse((boolean)retrieved.contains(unexpected));
        unexpected = "@org.springframework.beans.factory.annotation.Autowired";
        Assertions.assertFalse((boolean)retrieved.contains(unexpected));
    }

    @Test
    void compilationUnitWithSpring() {
        PredictionConfigGenerator predictionConfigGenerator = new PredictionConfigGenerator((KogitoBuildContext)new SpringBootKogitoBuildContext(s -> false), PACKAGE_NAME);
        Optional retrievedOpt = predictionConfigGenerator.generate();
        Assertions.assertNotNull((Object)retrievedOpt);
        Assertions.assertTrue((boolean)retrievedOpt.isPresent());
        String retrieved = new String(((GeneratedFile)retrievedOpt.get()).contents());
        String expected = "@org.springframework.stereotype.Component";
        Assertions.assertTrue((boolean)retrieved.contains(expected));
        expected = "@org.springframework.beans.factory.annotation.Autowired";
        Assertions.assertTrue((boolean)retrieved.contains(expected));
        String unexpected = "@javax.inject.Singleton";
        Assertions.assertFalse((boolean)retrieved.contains(unexpected));
        unexpected = "@javax.inject.Inject";
        Assertions.assertFalse((boolean)retrieved.contains(unexpected));
    }

    @Test
    void members() {
        PredictionConfigGenerator predictionConfigGenerator = new PredictionConfigGenerator((KogitoBuildContext)new QuarkusKogitoBuildContext(s -> false), PACKAGE_NAME);
        List retrieved = predictionConfigGenerator.members();
        Assertions.assertNotNull((Object)retrieved);
        Assertions.assertTrue((boolean)retrieved.isEmpty());
    }
}

