/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.process.events;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.context.KogitoBuildContext;
import org.kie.kogito.codegen.context.QuarkusKogitoBuildContext;
import org.kie.kogito.codegen.process.ProcessGenerationUtils;
import org.kie.kogito.codegen.process.events.CloudEventsResourceGenerator;

class CloudEventsResourceGeneratorTest {
    private final KogitoBuildContext buildContext = new QuarkusKogitoBuildContext(s -> true);

    CloudEventsResourceGeneratorTest() {
    }

    @Test
    void verifyBasicGenerationCase() {
        String sourceCode = new CloudEventsResourceGenerator(this.buildContext, "org.kie.kogito.app", Collections.emptyList()).generate();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)sourceCode);
        CompilationUnit clazz = StaticJavaParser.parse((String)sourceCode);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)clazz);
        Assertions.assertThat((List)clazz.getChildNodes()).isNotEmpty();
        Assertions.assertThat((List)clazz.getImports()).contains((Object[])new ImportDeclaration[]{new ImportDeclaration("org.kie.kogito.events.knative.ce.Printer", false, false)});
    }

    @Test
    void generatedFilePath() throws URISyntaxException {
        String filePath = new CloudEventsResourceGenerator(this.buildContext, "org.kie.kogito.app", Collections.emptyList()).generatedFilePath();
        Assertions.assertThat((String)new URI(filePath).toString()).endsWith((CharSequence)".java");
    }

    @Test
    void verifyProcessWithIntermediateEvent() {
        CloudEventsResourceGenerator generator = new CloudEventsResourceGenerator(this.buildContext, "org.kie.kogito.app", ProcessGenerationUtils.execModelFromProcessFile("/messageevent/IntermediateCatchEventMessage.bpmn2"));
        String source = generator.generate();
        Assertions.assertThat((String)source).isNotNull();
        Assertions.assertThat((List)generator.getTriggers()).hasSize(1);
        ClassOrInterfaceDeclaration clazz = (ClassOrInterfaceDeclaration)StaticJavaParser.parse((String)source).getClassByName("CloudEventListenerResource").orElseThrow(() -> new IllegalArgumentException("Class does not exists"));
        Assertions.assertThat((long)clazz.getFields().stream().filter(f -> f.getAnnotationByName("Channel").isPresent()).count()).isEqualTo(1L);
        Assertions.assertThat((long)clazz.getFields().stream().filter(f -> f.getAnnotationByName("Inject").isPresent()).count()).isEqualTo(2L);
    }

    @Test
    void verifyEmitterVariableNameGen() {
        CloudEventsResourceGenerator generator = new CloudEventsResourceGenerator(this.buildContext, "org.kie.kogito.app", Collections.emptyList());
        HashMap<String, String> tableTest = new HashMap<String, String>();
        tableTest.put("http://github.com/me/myrepo", "emitter_httpgithubcommemyrepo");
        tableTest.put("$%@1234whatever123", "emitter_1234whatever123");
        tableTest.put("123.12.34.56", "emitter_123123456");
        tableTest.put("this_is_a_test", "emitter_thisisatest");
        tableTest.forEach((key, value) -> Assertions.assertThat((String)generator.sanitizeEmitterName(key)).isEqualTo(value));
    }
}

