/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.tests;

import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.codegen.AbstractCodegenTest;
import org.kie.kogito.codegen.data.Person;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.Processes;
import org.kie.kogito.process.impl.Sig;

public class EventSubProcessTest
extends AbstractCodegenTest {
    @Test
    public void testEventSignalSubProcess() throws Exception {
        Application app = this.generateCodeProcessesOnly("event-subprocess/EventSubprocessSignal.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = ((Processes)app.get(Processes.class)).processById("EventSubprocessSignal");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        processInstance.send(Sig.of((String)"MySignal", null));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(3);
    }

    @Test
    public void testEventSignalSubProcessWithData() throws Exception {
        Application app = this.generateCodeProcessesOnly("event-subprocess/EventSubprocessSignalWithData.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = ((Processes)app.get(Processes.class)).processById("EventSubprocessSignal");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        processInstance.send(Sig.of((String)"MySignal", (Object)new Person("john", 20)));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKeys((Object[])new String[]{"person"});
        Person person = (Person)result.toMap().get("person");
        Assertions.assertThat((Object)person).isNotNull();
        Assertions.assertThat((String)person.getName()).isEqualTo("john");
    }
}

