/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.tests;

import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.jbpm.test.util.NodeLeftCountDownProcessEventListener;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.codegen.AbstractCodegenTest;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessConfig;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.Processes;

public class TimerEventTest
extends AbstractCodegenTest {
    @Test
    void testIntermediateCycleTimerEvent() throws Exception {
        Application app = this.generateCodeProcessesOnly("timer/IntermediateCatchEventTimerCycleISO.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        NodeLeftCountDownProcessEventListener listener = new NodeLeftCountDownProcessEventListener("timer", 3);
        ((ProcessConfig)app.config().get(ProcessConfig.class)).processEventListeners().listeners().add(listener);
        Process p = ((Processes)app.get(Processes.class)).processById("IntermediateCatchEvent");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        boolean completed = listener.waitTillCompleted(5000L);
        Assertions.assertThat((boolean)completed).isTrue();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        processInstance.abort();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(3);
    }

    @Test
    void testIntermediateDurationTimerEvent() throws Exception {
        Application app = this.generateCodeProcessesOnly("timer/IntermediateCatchEventTimerDurationISO.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        NodeLeftCountDownProcessEventListener listener = new NodeLeftCountDownProcessEventListener("timer", 1);
        ((ProcessConfig)app.config().get(ProcessConfig.class)).processEventListeners().listeners().add(listener);
        Process p = ((Processes)app.get(Processes.class)).processById("IntermediateCatchEvent");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        boolean completed = listener.waitTillCompleted(5000L);
        Assertions.assertThat((boolean)completed).isTrue();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }

    @Test
    void testIntermediateDateTimerEvent() throws Exception {
        Application app = this.generateCodeProcessesOnly("timer/IntermediateCatchEventTimerDateISO.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        NodeLeftCountDownProcessEventListener listener = new NodeLeftCountDownProcessEventListener("timer", 1);
        ((ProcessConfig)app.config().get(ProcessConfig.class)).processEventListeners().listeners().add(listener);
        Process p = ((Processes)app.get(Processes.class)).processById("IntermediateCatchEvent");
        Model m = (Model)p.createModel();
        HashMap<String, String> parameters = new HashMap<String, String>();
        OffsetDateTime plusTwoSeconds = OffsetDateTime.now().plusSeconds(2L);
        parameters.put("date", plusTwoSeconds.toString());
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        boolean completed = listener.waitTillCompleted(5000L);
        Assertions.assertThat((boolean)completed).isTrue();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }

    @Test
    void testBoundaryDurationTimerEventOnTask() throws Exception {
        Application app = this.generateCodeProcessesOnly("timer/TimerBoundaryEventDurationISOOnTask.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        NodeLeftCountDownProcessEventListener listener = new NodeLeftCountDownProcessEventListener("TimerEvent", 1);
        ((ProcessConfig)app.config().get(ProcessConfig.class)).processEventListeners().listeners().add(listener);
        Process p = ((Processes)app.get(Processes.class)).processById("TimerBoundaryEvent");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        boolean completed = listener.waitTillCompleted(5000L);
        Assertions.assertThat((boolean)completed).isTrue();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }

    @Test
    void testBoundaryCycleTimerEventOnTask() throws Exception {
        Application app = this.generateCodeProcessesOnly("timer/TimerBoundaryEventCycleISOOnTask.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        NodeLeftCountDownProcessEventListener listener = new NodeLeftCountDownProcessEventListener("TimerEvent", 1);
        ((ProcessConfig)app.config().get(ProcessConfig.class)).processEventListeners().listeners().add(listener);
        Process p = ((Processes)app.get(Processes.class)).processById("TimerBoundaryEvent");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        boolean completed = listener.waitTillCompleted(5000L);
        Assertions.assertThat((boolean)completed).isTrue();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }

    @Test
    void testBoundaryDateTimerEventOnTask() throws Exception {
        Application app = this.generateCodeProcessesOnly("timer/TimerBoundaryEventDateISOOnTask.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        NodeLeftCountDownProcessEventListener listener = new NodeLeftCountDownProcessEventListener("TimerEvent", 1);
        ((ProcessConfig)app.config().get(ProcessConfig.class)).processEventListeners().listeners().add(listener);
        Process p = ((Processes)app.get(Processes.class)).processById("TimerBoundaryEvent");
        Model m = (Model)p.createModel();
        HashMap<String, String> parameters = new HashMap<String, String>();
        OffsetDateTime plusTwoSeconds = OffsetDateTime.now().plusSeconds(2L);
        parameters.put("date", plusTwoSeconds.toString());
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        boolean completed = listener.waitTillCompleted(5000L);
        Assertions.assertThat((boolean)completed).isTrue();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }

    @Test
    void testBoundaryDurationTimerEventOnSubProcess() throws Exception {
        Application app = this.generateCodeProcessesOnly("timer/TimerBoundaryEventDurationISO.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        NodeLeftCountDownProcessEventListener listener = new NodeLeftCountDownProcessEventListener("TimerEvent", 1);
        ((ProcessConfig)app.config().get(ProcessConfig.class)).processEventListeners().listeners().add(listener);
        Process p = ((Processes)app.get(Processes.class)).processById("TimerBoundaryEvent");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        boolean completed = listener.waitTillCompleted(5000L);
        Assertions.assertThat((boolean)completed).isTrue();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }

    @Test
    void testStartTimerEvent() throws Exception {
        Application app = this.generateCodeProcessesOnly("timer/StartTimerDuration.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        NodeLeftCountDownProcessEventListener listener = new NodeLeftCountDownProcessEventListener("timer fired", 1);
        ((ProcessConfig)app.config().get(ProcessConfig.class)).processEventListeners().listeners().add(listener);
        Process p = ((Processes)app.get(Processes.class)).processById("defaultPackage.TimerProcess");
        p.activate();
        boolean completed = listener.waitTillCompleted(5000L);
        Assertions.assertThat((boolean)completed).isTrue();
        Collection instances = p.instances().values(ProcessInstanceReadMode.MUTABLE);
        Assertions.assertThat((Iterable)instances).hasSize(1);
        ProcessInstance processInstance = (ProcessInstance)instances.iterator().next();
        Assertions.assertThat((Object)processInstance).isNotNull();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        processInstance.abort();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(3);
        Assertions.assertThat((Integer)p.instances().size()).isZero();
    }

    @Test
    void testStartTimerEventTimeCycle() throws Exception {
        Application app = this.generateCodeProcessesOnly("timer/StartTimerCycle.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        NodeLeftCountDownProcessEventListener listener = new NodeLeftCountDownProcessEventListener("timer fired", 2);
        ((ProcessConfig)app.config().get(ProcessConfig.class)).processEventListeners().listeners().add(listener);
        Process p = ((Processes)app.get(Processes.class)).processById("defaultPackage.TimerProcess");
        p.activate();
        boolean completed = listener.waitTillCompleted(5000L);
        Assertions.assertThat((boolean)completed).isTrue();
        Collection instances = p.instances().values(ProcessInstanceReadMode.MUTABLE);
        Assertions.assertThat((Iterable)instances).hasSize(2);
        ProcessInstance processInstance = (ProcessInstance)instances.iterator().next();
        Assertions.assertThat((Object)processInstance).isNotNull();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        p.deactivate();
        listener.reset(1);
        completed = listener.waitTillCompleted(3000L);
        Assertions.assertThat((boolean)completed).isFalse();
        instances = p.instances().values(ProcessInstanceReadMode.MUTABLE);
        Assertions.assertThat((Iterable)instances).hasSize(2);
        instances.forEach(i -> ((ProcessInstance)i).abort());
        Assertions.assertThat((Integer)p.instances().size()).isZero();
    }
}

