/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.impl;

import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.codegen.AbstractCodegenTest;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.Processes;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.impl.ProcessTestUtils;
import org.kie.kogito.process.workitem.Policy;

class AdHocSubProcessTest
extends AbstractCodegenTest {
    AdHocSubProcessTest() {
    }

    @Test
    void testActivationAdHoc() throws Exception {
        Application app = this.generateCodeProcessesOnly("cases/ActivationAdHoc.bpmn");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = ((Processes)app.get(Processes.class)).processById("TestCase.ActivationAdHoc");
        Model model = (Model)p.createModel();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("favouriteColour", "yellow");
        model.fromMap(params);
        ProcessInstance processInstance = p.createInstance(model);
        ProcessTestUtils.assertState(processInstance, 0);
        processInstance.start();
        ProcessTestUtils.assertState(processInstance, 1);
        List workItems = processInstance.workItems(new Policy[0]);
        Assertions.assertThat((int)workItems.size()).isEqualTo(1);
        WorkItem workItem = (WorkItem)workItems.get(0);
        params = new HashMap();
        params.put("favouriteColour", "blue");
        processInstance.completeWorkItem(workItem.getId(), params, new Policy[0]);
        ProcessTestUtils.assertState(processInstance, 2);
    }

    @Test
    void testCompletionAdHoc() throws Exception {
        Application app = this.generateCodeProcessesOnly("cases/CompletionAdHoc.bpmn");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = ((Processes)app.get(Processes.class)).processById("TestCase.CompletionAdHoc");
        Model model = (Model)p.createModel();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("favouriteColour", "yellow");
        model.fromMap(params);
        ProcessInstance processInstance = p.createInstance(model);
        ProcessTestUtils.assertState(processInstance, 0);
        processInstance.start();
        ProcessTestUtils.assertState(processInstance, 1);
        List workItems = processInstance.workItems(new Policy[0]);
        Assertions.assertThat((int)workItems.size()).isEqualTo(1);
        WorkItem workItem = (WorkItem)workItems.get(0);
        workItem.getParameters().put("favouriteColour", "green");
        params.put("favouriteColour", "green");
        processInstance.completeWorkItem(workItem.getId(), params, new Policy[0]);
        ProcessTestUtils.assertState(processInstance, 2);
    }
}

