/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.dmn;

import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.core.io.impl.ReaderResource;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.internal.utils.DMNEvaluationUtils;
import org.kie.dmn.core.internal.utils.DMNRuntimeBuilder;
import org.kie.kogito.dmn.rest.DMNResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNKogito {
    private static final Logger LOG = LoggerFactory.getLogger(DMNKogito.class);

    private DMNKogito() {
    }

    public static DMNRuntime createGenericDMNRuntime(Reader ... readers) {
        List resources = Stream.of(readers).map(ReaderResource::new).collect(Collectors.toList());
        DMNRuntime dmnRuntime = (DMNRuntime)DMNRuntimeBuilder.fromDefaults().buildConfiguration().fromResources(resources).getOrElseThrow(e -> new RuntimeException("Error initalizing DMNRuntime", (Throwable)e));
        return dmnRuntime;
    }

    public static DMNModel modelByName(DMNRuntime dmnRuntime, String modelName) {
        List modelsWithName = dmnRuntime.getModels().stream().filter(m -> modelName.equals(m.getName())).collect(Collectors.toList());
        if (modelsWithName.size() == 1) {
            return (DMNModel)modelsWithName.get(0);
        }
        throw new RuntimeException("Multiple model with the same name: " + modelName);
    }

    public static DMNResult evaluate(DMNRuntime dmnRuntime, String modelName, Map<String, Object> dmnContext) {
        return DMNKogito.evaluate(dmnRuntime, DMNKogito.modelByName(dmnRuntime, modelName).getNamespace(), modelName, dmnContext);
    }

    public static DMNResult evaluate(DMNRuntime dmnRuntime, String modelNamespace, String modelName, Map<String, Object> dmnContext) {
        DMNEvaluationUtils.DMNEvaluationResult evaluationResult = DMNEvaluationUtils.evaluate((DMNRuntime)dmnRuntime, (String)modelNamespace, (String)modelName, dmnContext, null, null, null);
        return new DMNResult(modelNamespace, modelName, evaluationResult.result);
    }
}

