/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.dmn.rest;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.json.bind.annotation.JsonbProperty;
import org.kie.dmn.model.api.ItemDefinition;
import org.kie.kogito.dmn.rest.DMNUnaryTestsInfo;

public class DMNItemDefinitionInfo
implements Serializable {
    private String id;
    private String name;
    private String typeRef;
    private DMNUnaryTestsInfo allowedValues;
    private List<DMNItemDefinitionInfo> itemComponent = new ArrayList<DMNItemDefinitionInfo>();
    private String typeLanguage;
    private Boolean isCollection;

    public static DMNItemDefinitionInfo of(ItemDefinition itemDef) {
        DMNItemDefinitionInfo res = new DMNItemDefinitionInfo();
        res.setId(itemDef.getId());
        res.setName(itemDef.getName());
        if (itemDef.getTypeRef() != null) {
            res.setTypeRef(itemDef.getTypeRef().getLocalPart());
        }
        if (itemDef.getAllowedValues() != null) {
            DMNUnaryTestsInfo av = new DMNUnaryTestsInfo();
            av.setText(itemDef.getAllowedValues().getText());
            av.setExpressionLanguage(itemDef.getAllowedValues().getExpressionLanguage());
            res.setAllowedValues(av);
        }
        if (itemDef.getItemComponent() != null && !itemDef.getItemComponent().isEmpty()) {
            List<DMNItemDefinitionInfo> components = itemDef.getItemComponent().stream().map(DMNItemDefinitionInfo::of).collect(Collectors.toList());
            res.setItemComponent(components);
        }
        res.setTypeLanguage(itemDef.getTypeLanguage());
        res.setIsCollection(itemDef.isIsCollection());
        return res;
    }

    @JsonbProperty(value="itemdefinition-id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @JsonbProperty(value="itemdefinition-name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonbProperty(value="itemdefinition-typeRef")
    public String getTypeRef() {
        return this.typeRef;
    }

    public void setTypeRef(String typeRef) {
        this.typeRef = typeRef;
    }

    @JsonbProperty(value="itemdefinition-allowedValues")
    public DMNUnaryTestsInfo getAllowedValues() {
        return this.allowedValues;
    }

    public void setAllowedValues(DMNUnaryTestsInfo allowedValues) {
        this.allowedValues = allowedValues;
    }

    @JsonbProperty(value="itemdefinition-itemComponent")
    public List<DMNItemDefinitionInfo> getItemComponent() {
        return this.itemComponent;
    }

    public void setItemComponent(List<DMNItemDefinitionInfo> itemComponent) {
        this.itemComponent = itemComponent;
    }

    @JsonbProperty(value="itemdefinition-typeLanguage")
    public String getTypeLanguage() {
        return this.typeLanguage;
    }

    public void setTypeLanguage(String typeLanguage) {
        this.typeLanguage = typeLanguage;
    }

    @JsonbProperty(value="itemdefinition-isCollection")
    public Boolean getIsCollection() {
        return this.isCollection;
    }

    public void setIsCollection(Boolean isCollection) {
        this.isCollection = isCollection;
    }
}

