/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.dmn;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.KogitoGAV;
import org.kie.kogito.ModelDomain;
import org.kie.kogito.decision.DecisionModelMetadata;
import org.kie.kogito.dmn.DefaultDecisionModelResource;

public class DefaultDecisionModelResourceTest {
    private static final KogitoGAV GAV = new KogitoGAV("groupID", "artifactId", "version");
    private static final String CONTENT = "content";

    @Test
    public void testGetters() {
        DefaultDecisionModelResource resource = new DefaultDecisionModelResource(GAV, "namespace", "name", new DecisionModelMetadata("http://www.omg.org/spec/DMN/20151101/dmn.xsd"), new InputStreamReader(new ByteArrayInputStream(CONTENT.getBytes())));
        Assertions.assertEquals((Object)GAV, (Object)resource.getGav());
        Assertions.assertEquals((Object)"name", (Object)resource.getModelName());
        Assertions.assertEquals((Object)"namespace", (Object)resource.getNamespace());
        Assertions.assertEquals((Object)ModelDomain.DECISION, (Object)resource.getModelMetadata().getModelDomain());
        Assertions.assertEquals((Object)"http://www.omg.org/spec/DMN/20151101/dmn.xsd", (Object)resource.getModelMetadata().getSpecVersion());
    }

    @Test
    public void testLoad() {
        DefaultDecisionModelResource resource = new DefaultDecisionModelResource(GAV, "namespace", "name", new DecisionModelMetadata("http://www.omg.org/spec/DMN/20151101/dmn.xsd"), new InputStreamReader(new ByteArrayInputStream(CONTENT.getBytes())));
        Assertions.assertEquals((Object)CONTENT, (Object)((String)resource.get()).trim());
    }
}

