/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.dmn;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.function.BiFunction;
import org.drools.util.IoUtils;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.feel.util.ClassLoaderUtil;
import org.kie.kogito.Application;
import org.kie.kogito.ExecutionIdSupplier;
import org.kie.kogito.KogitoGAV;
import org.kie.kogito.conf.ConfigBean;
import org.kie.kogito.decision.DecisionConfig;
import org.kie.kogito.decision.DecisionModel;
import org.kie.kogito.decision.DecisionModels;
import org.kie.kogito.dmn.DMNKogito;
import org.kie.kogito.dmn.DMNKogitoCallbacks;
import org.kie.kogito.dmn.DmnDecisionModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDecisionModels
implements DecisionModels {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDecisionModels.class);
    private static final boolean CAN_PLATFORM_CLASSLOAD = ClassLoaderUtil.CAN_PLATFORM_CLASSLOAD;
    private static DMNRuntime dmnRuntime = null;
    private static ExecutionIdSupplier execIdSupplier = null;
    private static BiFunction<DecisionModel, KogitoGAV, DecisionModel> decisionModelTransformer = null;
    private KogitoGAV gav = KogitoGAV.EMPTY_GAV;

    protected static void init(ExecutionIdSupplier executionIdSupplier, BiFunction<DecisionModel, KogitoGAV, DecisionModel> decisionModelTransformerInit, Reader ... readers) {
        DMNKogitoCallbacks.beforeAbstractDecisionModelsInit(executionIdSupplier, decisionModelTransformerInit, readers);
        dmnRuntime = DMNKogito.createGenericDMNRuntime(readers);
        execIdSupplier = executionIdSupplier;
        decisionModelTransformer = decisionModelTransformerInit;
        DMNKogitoCallbacks.afterAbstractDecisionModelsInit(dmnRuntime);
    }

    public DecisionModel getDecisionModel(String namespace, String name) {
        DmnDecisionModel model = new DmnDecisionModel(dmnRuntime, namespace, name, execIdSupplier);
        return decisionModelTransformer == null ? model : decisionModelTransformer.apply(model, this.gav);
    }

    public AbstractDecisionModels() {
    }

    public AbstractDecisionModels(Application app) {
        this.initApplication(app);
    }

    protected void initApplication(Application app) {
        ((DecisionConfig)app.config().get(DecisionConfig.class)).decisionEventListeners().listeners().forEach(arg_0 -> ((DMNRuntime)dmnRuntime).addListener(arg_0));
        this.gav = ((ConfigBean)app.config().get(ConfigBean.class)).getGav().orElse(KogitoGAV.EMPTY_GAV);
    }

    @Deprecated
    protected static InputStreamReader readResource(InputStream stream) {
        Charset defaultEncoding = Charset.defaultCharset();
        return AbstractDecisionModels.readResource(stream, defaultEncoding.name());
    }

    protected static InputStreamReader readResource(InputStream stream, String encoding) {
        if (CAN_PLATFORM_CLASSLOAD) {
            return AbstractDecisionModels.isrWithEncodingOrFallback(stream, encoding);
        }
        try {
            byte[] bytes = IoUtils.readBytesFromInputStream((InputStream)stream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            return AbstractDecisionModels.isrWithEncodingOrFallback(byteArrayInputStream, encoding);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static InputStreamReader isrWithEncodingOrFallback(InputStream stream, String encoding) {
        try {
            return new InputStreamReader(stream, encoding);
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn("Unable to create Reader using encoding {}, will use fallback Reader.", (Object)encoding);
            return new InputStreamReader(stream);
        }
    }
}

