/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.dmn;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.kogito.dmn.DMNKogito;
import org.kie.kogito.dmn.DmnDecisionModel;

public class DMNKogitoTest {
    @Test
    public void testBasic() {
        DMNRuntime dmnRuntime = DMNKogito.createGenericDMNRuntime((Reader[])new Reader[]{new InputStreamReader(DMNKogitoTest.class.getResourceAsStream("TrafficViolation.dmn"))});
        Assertions.assertThat((List)dmnRuntime.getModels()).hasSize(1);
        String TRAFFIC_VIOLATION_NS = "https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF";
        String TRAFFIC_VIOLATION_NAME = "Traffic Violation";
        DmnDecisionModel kogitoAPI = new DmnDecisionModel(dmnRuntime, "https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF", "Traffic Violation");
        Assertions.assertThat((String)kogitoAPI.getDMNModel().getNamespace()).isEqualTo("https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF");
        Assertions.assertThat((String)kogitoAPI.getDMNModel().getName()).isEqualTo("Traffic Violation");
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)kogitoAPI.getDMNModel().getInputs()).as("Traffic Violation model has 2 inputs", new Object[0])).hasSize(2);
    }

    @Test
    public void testProfile() {
        DMNRuntime dmnRuntime = DMNKogito.createGenericDMNRuntime((Reader[])new Reader[]{new InputStreamReader(DMNKogitoTest.class.getResourceAsStream("profile.dmn"))});
        Assertions.assertThat((List)dmnRuntime.getModels()).hasSize(1);
        DMNModel dmnModel = (DMNModel)dmnRuntime.getModels().get(0);
        Assertions.assertThat((List)dmnModel.getMessages(new DMNMessage.Severity[]{DMNMessage.Severity.ERROR})).isEmpty();
    }
}

