/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.dmn;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.KogitoGAV;
import org.kie.kogito.ModelDomain;
import org.kie.kogito.decision.DecisionModelMetadata;
import org.kie.kogito.dmn.DefaultDecisionModelResource;

public class DefaultDecisionModelResourceTest {
    private static final KogitoGAV GAV = new KogitoGAV("groupID", "artifactId", "version");
    private static final String CONTENT = "content";

    @Test
    public void testGetters() {
        DefaultDecisionModelResource resource = new DefaultDecisionModelResource(GAV, "namespace", "name", new DecisionModelMetadata("http://www.omg.org/spec/DMN/20151101/dmn.xsd"), new InputStreamReader(new ByteArrayInputStream(CONTENT.getBytes())));
        Assertions.assertThat((Object)resource.getGav()).isEqualTo((Object)GAV);
        Assertions.assertThat((String)resource.getModelName()).isEqualTo("name");
        Assertions.assertThat((String)resource.getNamespace()).isEqualTo("namespace");
        Assertions.assertThat((Comparable)resource.getModelMetadata().getModelDomain()).isEqualTo((Object)ModelDomain.DECISION);
        Assertions.assertThat((String)resource.getModelMetadata().getSpecVersion()).isEqualTo("http://www.omg.org/spec/DMN/20151101/dmn.xsd");
    }

    @Test
    public void testLoad() {
        DefaultDecisionModelResource resource = new DefaultDecisionModelResource(GAV, "namespace", "name", new DecisionModelMetadata("http://www.omg.org/spec/DMN/20151101/dmn.xsd"), new InputStreamReader(new ByteArrayInputStream(CONTENT.getBytes())));
        Assertions.assertThat((String)((String)resource.get()).trim()).isEqualTo(CONTENT);
    }
}

