/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.dmn;

import java.io.InputStreamReader;
import java.io.Reader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.kogito.dmn.DMNKogito;
import org.kie.kogito.dmn.DmnDecisionModel;

public class DMNKogitoTest {
    @Test
    public void testBasic() {
        DMNRuntime dmnRuntime = DMNKogito.createGenericDMNRuntime((Reader[])new Reader[]{new InputStreamReader(DMNKogitoTest.class.getResourceAsStream("TrafficViolation.dmn"))});
        Assertions.assertEquals((int)1, (int)dmnRuntime.getModels().size());
        String TRAFFIC_VIOLATION_NS = "https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF";
        String TRAFFIC_VIOLATION_NAME = "Traffic Violation";
        DmnDecisionModel kogitoAPI = new DmnDecisionModel(dmnRuntime, "https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF", "Traffic Violation");
        Assertions.assertEquals((Object)"https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF", (Object)kogitoAPI.getDMNModel().getNamespace());
        Assertions.assertEquals((Object)"Traffic Violation", (Object)kogitoAPI.getDMNModel().getName());
        Assertions.assertEquals((int)2, (int)kogitoAPI.getDMNModel().getInputs().size(), (String)"Traffic Violation model has 2 inputs");
    }

    @Test
    public void testProfile() {
        DMNRuntime dmnRuntime = DMNKogito.createGenericDMNRuntime((Reader[])new Reader[]{new InputStreamReader(DMNKogitoTest.class.getResourceAsStream("profile.dmn"))});
        Assertions.assertEquals((int)1, (int)dmnRuntime.getModels().size());
        DMNModel dmnModel = (DMNModel)dmnRuntime.getModels().get(0);
        Assertions.assertEquals((int)0, (int)dmnModel.getMessages(new DMNMessage.Severity[]{DMNMessage.Severity.ERROR}).size());
    }
}

