/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.eventdriven.decision;

import com.fasterxml.jackson.databind.JsonNode;
import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventExtensions;
import io.cloudevents.core.provider.ExtensionProvider;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.kogito.cloudevents.CloudEventUtils;
import org.kie.kogito.cloudevents.extension.KogitoExtension;
import org.kie.kogito.conf.ConfigBean;
import org.kie.kogito.decision.DecisionModel;
import org.kie.kogito.decision.DecisionModels;
import org.kie.kogito.decision.DecisionTestUtils;
import org.kie.kogito.dmn.DmnDecisionModel;
import org.kie.kogito.event.CloudEventEmitter;
import org.kie.kogito.event.CloudEventReceiver;
import org.kie.kogito.eventdriven.decision.DecisionResponseError;
import org.kie.kogito.eventdriven.decision.EventDrivenDecisionController;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class EventDrivenDecisionControllerTest {
    private static final String MODEL_NAME_PLACEHOLDER = "%%MODEL_NAME%%";
    private static final String MODEL_NAMESPACE_PLACEHOLDER = "%%MODEL_NAMESPACE%%";
    private static final String EVALUATE_DECISION_PLACEHOLDER = "%%EVALUATE_DECISION%%";
    private static final String FULL_RESULT_PLACEHOLDER = "%%FULL_RESULT%%";
    private static final String FILTERED_CTX_PLACEHOLDER = "%%FILTERED_CTX%%";
    private static final String DATA_PLACEHOLDER = "%%DATA%%";
    private static final String CLOUDEVENT_ID = "a89b61a2-5644-487a-8a86-144855c5dce8";
    private static final String CLOUDEVENT_SOURCE = "SomeEventSource";
    private static final String CLOUDEVENT_SUBJECT = "TheSubject";
    private static final String CLOUDEVENT_TEMPLATE = "{\n    \"specversion\": \"1.0\",\n    \"id\": \"a89b61a2-5644-487a-8a86-144855c5dce8\",\n    \"source\": \"SomeEventSource\",\n    \"type\": \"DecisionRequest\",\n    \"subject\": \"TheSubject\",\n    \"kogitodmnmodelname\": %%MODEL_NAME%%,\n    \"kogitodmnmodelnamespace\": %%MODEL_NAMESPACE%%,\n    \"kogitodmnevaldecision\": %%EVALUATE_DECISION%%,\n    \"kogitodmnfullresult\": %%FULL_RESULT%%,\n    \"kogitodmnfilteredctx\": %%FILTERED_CTX%%,\n    \"data\": %%DATA%%\n}";
    private static final String CLOUDEVENT_IGNORED = "{\n    \"specversion\": \"1.0\",\n    \"id\": \"55c5dce8-5644-487a-8a86-1448a89b61a2\",\n    \"source\": \"SomeOtherEventSource\",\n    \"type\": \"SomeType\",\n    \"data\": {}\n}";
    private static final List<RequestData> REQUEST_DATA_BAD_REQUEST = Stream.of(new RequestData(null, null, null, null), new RequestData("aName", null, null, null), new RequestData(null, "aNamespace", null, null), new RequestData(null, null, null, "{}"), new RequestData("aName", "aNamespace", null, null), new RequestData("aName", null, null, "{}"), new RequestData(null, "aNamespace", null, "{}")).collect(Collectors.toList());
    private static final RequestData REQUEST_DATA_MODEL_NOT_FOUND = new RequestData("aName", "aNamespace", null, "{}");
    private static final RequestData REQUEST_DATA_NULL_CONTEXT = new RequestData("Traffic Violation", "https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF", null, null);
    private static final RequestData REQUEST_DATA_EVALUATE_ALL = new RequestData("Traffic Violation", "https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF", null, "{\n    \"Driver\": {\n        \"Age\": 25,\n        \"Points\": 13\n    },\n    \"Violation\": {\n        \"Type\": \"speed\",\n        \"Actual Speed\": 115,\n        \"Speed Limit\": 100\n    }\n}");
    private static final RequestData REQUEST_DATA_EVALUATE_DECISION_SERVICE = new RequestData("Traffic Violation", "https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF", "FineService", "{\n    \"Violation\": {\n        \"Type\": \"speed\",\n        \"Actual Speed\": 115,\n        \"Speed Limit\": 100\n    }\n}");
    private static final String TEST_EXECUTION_ID = "11ecbb6f-fb25-4597-88c8-ac7976efe078";
    private static DMNRuntime runtime;
    private EventDrivenDecisionController controller;
    private CloudEventEmitter eventEmitterMock;
    private DecisionModel decisionModelSpy;
    private DecisionModels decisionModelsMock;

    EventDrivenDecisionControllerTest() {
    }

    @BeforeAll
    static void beforeAll() {
        ExtensionProvider.getInstance().registerExtension(KogitoExtension.class, KogitoExtension::new);
        runtime = DecisionTestUtils.createDMNRuntime();
    }

    @BeforeEach
    void beforeEach() {
        this.decisionModelsMock = (DecisionModels)Mockito.mock(DecisionModels.class);
        this.eventEmitterMock = (CloudEventEmitter)Mockito.mock(CloudEventEmitter.class);
        this.mockDecisionModel();
        this.controller = new EventDrivenDecisionController(this.decisionModelsMock, (ConfigBean)Mockito.mock(ConfigBean.class), this.eventEmitterMock, (CloudEventReceiver)Mockito.mock(CloudEventReceiver.class));
    }

    @Test
    void testSubscribe() {
        DecisionModels decisionModelsMock = (DecisionModels)Mockito.mock(DecisionModels.class);
        ConfigBean configMock = (ConfigBean)Mockito.mock(ConfigBean.class);
        CloudEventEmitter eventEmitterMock = (CloudEventEmitter)Mockito.mock(CloudEventEmitter.class);
        CloudEventReceiver eventReceiverMock = (CloudEventReceiver)Mockito.mock(CloudEventReceiver.class);
        EventDrivenDecisionController controller1 = new EventDrivenDecisionController(decisionModelsMock, configMock, eventEmitterMock, eventReceiverMock);
        controller1.setup();
        ((CloudEventReceiver)Mockito.verify((Object)eventReceiverMock)).subscribe((Consumer)ArgumentMatchers.any());
        Mockito.reset((Object[])new CloudEventReceiver[]{eventReceiverMock});
        EventDrivenDecisionController controller2 = new EventDrivenDecisionController();
        controller2.setup(decisionModelsMock, configMock, eventEmitterMock, eventReceiverMock);
        ((CloudEventReceiver)Mockito.verify((Object)eventReceiverMock)).subscribe((Consumer)ArgumentMatchers.any());
    }

    @Test
    void testHandleEventWithMalformedInput() {
        this.controller.handleEvent("this-is-not-a-cloudevent");
        ((CloudEventEmitter)Mockito.verify((Object)this.eventEmitterMock, (VerificationMode)Mockito.never())).emit((String)ArgumentMatchers.any());
    }

    @Test
    void testHandleEventWithIgnoredCloudEvent() {
        this.controller.handleEvent(CLOUDEVENT_IGNORED);
        ((CloudEventEmitter)Mockito.verify((Object)this.eventEmitterMock, (VerificationMode)Mockito.never())).emit((String)ArgumentMatchers.any());
    }

    @Test
    void testHandleEventWithValidCloudEventWithNullDataProducingBadRequest() {
        this.testAllErrorCloudEventEmittedCombinations(REQUEST_DATA_NULL_CONTEXT, DecisionResponseError.BAD_REQUEST);
    }

    @Test
    void testHandleEventWithValidCloudEventProducingOkEvaluateAll() {
        this.testAllDefaultAndFullCloudEventEmittedCombinations(REQUEST_DATA_EVALUATE_ALL, (cloudEvent, kogitoExtension, responseEvent) -> {
            Assert.assertNull((Object)kogitoExtension.getExecutionId());
            ((DecisionModel)Mockito.verify((Object)this.decisionModelSpy)).evaluateAll((DMNContext)ArgumentMatchers.notNull());
            ((DecisionModel)Mockito.verify((Object)this.decisionModelSpy, (VerificationMode)Mockito.never())).evaluateDecisionService((DMNContext)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
            Mockito.clearInvocations((Object[])new DecisionModel[]{this.decisionModelSpy});
        });
    }

    @Test
    void testHandleEventWithValidCloudEventWithExecutionIdProducingOkEvaluateAll() {
        this.mockDecisionModelWithExecutionIdSupplier();
        this.testAllDefaultAndFullCloudEventEmittedCombinations(REQUEST_DATA_EVALUATE_ALL, (cloudEvent, kogitoExtension, responseEvent) -> {
            Assert.assertEquals((Object)TEST_EXECUTION_ID, (Object)kogitoExtension.getExecutionId());
            ((DecisionModel)Mockito.verify((Object)this.decisionModelSpy)).evaluateAll((DMNContext)ArgumentMatchers.notNull());
            ((DecisionModel)Mockito.verify((Object)this.decisionModelSpy, (VerificationMode)Mockito.never())).evaluateDecisionService((DMNContext)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
            Mockito.clearInvocations((Object[])new DecisionModel[]{this.decisionModelSpy});
        });
    }

    @Test
    void testHandleEventWithValidCloudEventProducingOkEvaluateDecisionService() {
        this.testAllDefaultAndFullCloudEventEmittedCombinations(REQUEST_DATA_EVALUATE_DECISION_SERVICE, (cloudEvent, kogitoExtension, responseEvent) -> {
            Assert.assertNull((Object)kogitoExtension.getExecutionId());
            ((DecisionModel)Mockito.verify((Object)this.decisionModelSpy, (VerificationMode)Mockito.never())).evaluateAll((DMNContext)ArgumentMatchers.any());
            ((DecisionModel)Mockito.verify((Object)this.decisionModelSpy)).evaluateDecisionService((DMNContext)ArgumentMatchers.notNull(), (String)ArgumentMatchers.notNull());
            Mockito.clearInvocations((Object[])new DecisionModel[]{this.decisionModelSpy});
        });
    }

    @Test
    void testHandleEventWithValidCloudEventWithExecutionIdProducingOkEvaluateDecisionService() {
        this.mockDecisionModelWithExecutionIdSupplier();
        this.testAllDefaultAndFullCloudEventEmittedCombinations(REQUEST_DATA_EVALUATE_DECISION_SERVICE, (cloudEvent, kogitoExtension, responseEvent) -> {
            Assert.assertEquals((Object)TEST_EXECUTION_ID, (Object)kogitoExtension.getExecutionId());
            ((DecisionModel)Mockito.verify((Object)this.decisionModelSpy, (VerificationMode)Mockito.never())).evaluateAll((DMNContext)ArgumentMatchers.any());
            ((DecisionModel)Mockito.verify((Object)this.decisionModelSpy)).evaluateDecisionService((DMNContext)ArgumentMatchers.notNull(), (String)ArgumentMatchers.notNull());
            Mockito.clearInvocations((Object[])new DecisionModel[]{this.decisionModelSpy});
        });
    }

    @Test
    void testHandleEventWithValidCloudEventProducingBadRequest() {
        for (RequestData badRequestData : REQUEST_DATA_BAD_REQUEST) {
            this.testAllErrorCloudEventEmittedCombinations(badRequestData, DecisionResponseError.BAD_REQUEST);
        }
    }

    @Test
    void testHandleEventWithValidCloudEventWithExecutionIdProducingBadRequest() {
        this.mockDecisionModelWithExecutionIdSupplier();
        for (RequestData badRequestData : REQUEST_DATA_BAD_REQUEST) {
            this.testAllErrorCloudEventEmittedCombinations(badRequestData, DecisionResponseError.BAD_REQUEST);
        }
    }

    @Test
    void testHandleEventWithValidCloudEventProducingNotFound() {
        this.testAllErrorCloudEventEmittedCombinations(REQUEST_DATA_MODEL_NOT_FOUND, DecisionResponseError.MODEL_NOT_FOUND);
    }

    @Test
    void testHandleEventWithValidCloudEventWithExecutionIdProducingNotFound() {
        this.mockDecisionModelWithExecutionIdSupplier();
        this.testAllErrorCloudEventEmittedCombinations(REQUEST_DATA_MODEL_NOT_FOUND, DecisionResponseError.MODEL_NOT_FOUND);
    }

    private void assertSubject(CloudEvent event) {
        Assert.assertNotNull((Object)event.getSubject());
        Assert.assertEquals((Object)CLOUDEVENT_SUBJECT, (Object)event.getSubject());
    }

    private String cloudEventOkWith(RequestData requestData, Boolean fullResult, Boolean filteredCtx) {
        return CLOUDEVENT_TEMPLATE.replace(MODEL_NAME_PLACEHOLDER, this.format(requestData.getModelName())).replace(MODEL_NAMESPACE_PLACEHOLDER, this.format(requestData.getModelNamespace())).replace(EVALUATE_DECISION_PLACEHOLDER, this.format(requestData.getDecision())).replace(FULL_RESULT_PLACEHOLDER, fullResult == null ? "null" : fullResult.toString()).replace(FILTERED_CTX_PLACEHOLDER, filteredCtx == null ? "null" : filteredCtx.toString()).replace(DATA_PLACEHOLDER, Optional.ofNullable(requestData.getData()).orElse("null"));
    }

    private String format(String input) {
        return Optional.ofNullable(input).map(i -> "\"" + i + "\"").orElse("null");
    }

    private void mockDecisionModel() {
        this.decisionModelSpy = (DecisionModel)Mockito.spy((Object)new DmnDecisionModel(runtime, "https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF", "Traffic Violation"));
        Mockito.when((Object)this.decisionModelsMock.getDecisionModel((String)ArgumentMatchers.eq((Object)"https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF"), (String)ArgumentMatchers.eq((Object)"Traffic Violation"))).thenReturn((Object)this.decisionModelSpy);
    }

    private void mockDecisionModelWithExecutionIdSupplier() {
        this.decisionModelSpy = (DecisionModel)Mockito.spy((Object)new DmnDecisionModel(runtime, "https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF", "Traffic Violation", () -> TEST_EXECUTION_ID));
        Mockito.when((Object)this.decisionModelsMock.getDecisionModel((String)ArgumentMatchers.eq((Object)"https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF"), (String)ArgumentMatchers.eq((Object)"Traffic Violation"))).thenReturn((Object)this.decisionModelSpy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void testCloudEventEmitted(RequestData requestData, Boolean fullResult, Boolean filteredCtx, Class<T> responseDataClass, String expectedType, TriConsumer<CloudEvent, KogitoExtension, T> callback) {
        try {
            ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(String.class);
            String inputEvent = this.cloudEventOkWith(requestData, fullResult, filteredCtx);
            this.controller.handleEvent(inputEvent);
            ((CloudEventEmitter)Mockito.verify((Object)this.eventEmitterMock)).emit((String)eventCaptor.capture());
            String emittedCloudEventJson = (String)eventCaptor.getValue();
            Optional optEmittedCloudEvent = CloudEventUtils.decode((String)emittedCloudEventJson);
            if (!optEmittedCloudEvent.isPresent()) {
                Assert.fail((String)"Can't decode emitted CloudEvent");
            }
            CloudEvent emittedCloudEvent = (CloudEvent)optEmittedCloudEvent.get();
            Assert.assertEquals((Object)expectedType, (Object)emittedCloudEvent.getType());
            KogitoExtension kogitoExtension = (KogitoExtension)ExtensionProvider.getInstance().parseExtension(KogitoExtension.class, (CloudEventExtensions)emittedCloudEvent);
            if (kogitoExtension == null) {
                Assert.fail((String)("No Kogito extension in emitted CloudEvent: " + emittedCloudEventJson));
            }
            Assert.assertEquals((Object)requestData.getModelName(), (Object)kogitoExtension.getDmnModelName());
            Assert.assertEquals((Object)requestData.getModelNamespace(), (Object)kogitoExtension.getDmnModelNamespace());
            Assert.assertEquals((Object)requestData.getDecision(), (Object)kogitoExtension.getDmnEvaluateDecision());
            Optional optResponseEvent = CloudEventUtils.decodeData((CloudEvent)emittedCloudEvent, responseDataClass);
            if (!optResponseEvent.isPresent()) {
                Assert.fail((String)("Can't decode emitted CloudEvent data of: " + emittedCloudEventJson));
            }
            this.assertSubject(emittedCloudEvent);
            if (callback != null) {
                callback.accept(emittedCloudEvent, kogitoExtension, (CloudEvent)optResponseEvent.get());
            }
        }
        catch (Throwable throwable) {
            Mockito.reset((Object[])new CloudEventEmitter[]{this.eventEmitterMock});
            throw throwable;
        }
        Mockito.reset((Object[])new CloudEventEmitter[]{this.eventEmitterMock});
    }

    private void testDefaultCloudEventEmitted(RequestData requestData, Boolean fullResult, Boolean filteredCtx, TriConsumer<CloudEvent, KogitoExtension, JsonNode> callback) {
        this.testCloudEventEmitted(requestData, fullResult, filteredCtx, JsonNode.class, "DecisionResponse", (cloudEvent, kogitoExtension, data) -> {
            if (data.isObject()) {
                Assert.assertFalse((boolean)data.hasNonNull("namespace"));
                Assert.assertFalse((boolean)data.hasNonNull("modelName"));
                Assert.assertFalse((boolean)data.hasNonNull("dmnContext"));
                Assert.assertFalse((boolean)data.hasNonNull("messages"));
                Assert.assertFalse((boolean)data.hasNonNull("decisionResults"));
            }
            callback.accept((CloudEvent)cloudEvent, (KogitoExtension)kogitoExtension, (JsonNode)data);
        });
    }

    private void testFullCloudEventEmitted(RequestData requestData, Boolean fullResult, Boolean filteredCtx, TriConsumer<CloudEvent, KogitoExtension, JsonNode> callback) {
        this.testCloudEventEmitted(requestData, fullResult, filteredCtx, JsonNode.class, "DecisionResponseFull", (cloudEvent, kogitoExtension, data) -> {
            Assert.assertTrue((boolean)data.isObject());
            Assert.assertTrue((boolean)data.hasNonNull("namespace"));
            Assert.assertTrue((boolean)data.hasNonNull("modelName"));
            Assert.assertTrue((boolean)data.hasNonNull("dmnContext"));
            Assert.assertTrue((boolean)data.hasNonNull("messages"));
            Assert.assertTrue((boolean)data.hasNonNull("decisionResults"));
            callback.accept((CloudEvent)cloudEvent, (KogitoExtension)kogitoExtension, (JsonNode)data);
        });
    }

    private void testAllDefaultAndFullCloudEventEmittedCombinations(RequestData requestData, TriConsumer<CloudEvent, KogitoExtension, JsonNode> consumer) {
        this.testDefaultCloudEventEmitted(requestData, null, null, consumer);
        this.testDefaultCloudEventEmitted(requestData, null, false, consumer);
        this.testDefaultCloudEventEmitted(requestData, null, true, consumer);
        this.testDefaultCloudEventEmitted(requestData, false, null, consumer);
        this.testDefaultCloudEventEmitted(requestData, false, false, consumer);
        this.testDefaultCloudEventEmitted(requestData, false, true, consumer);
        this.testFullCloudEventEmitted(requestData, true, null, consumer);
        this.testFullCloudEventEmitted(requestData, true, false, consumer);
        this.testFullCloudEventEmitted(requestData, true, true, consumer);
    }

    private void testErrorCloudEventEmitted(RequestData requestData, Boolean fullResult, Boolean filteredCtx, DecisionResponseError expectedError) {
        this.testCloudEventEmitted(requestData, fullResult, filteredCtx, DecisionResponseError.class, "DecisionResponseError", (cloudEvent, kogitoExtension, data) -> {
            Assert.assertSame((Object)expectedError, (Object)data);
            Assert.assertNull((Object)kogitoExtension.getExecutionId());
            ((DecisionModel)Mockito.verify((Object)this.decisionModelSpy, (VerificationMode)Mockito.never())).evaluateAll((DMNContext)ArgumentMatchers.any());
            ((DecisionModel)Mockito.verify((Object)this.decisionModelSpy, (VerificationMode)Mockito.never())).evaluateDecisionService((DMNContext)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        });
    }

    private void testAllErrorCloudEventEmittedCombinations(RequestData requestData, DecisionResponseError expectedError) {
        this.testErrorCloudEventEmitted(requestData, null, null, expectedError);
        this.testErrorCloudEventEmitted(requestData, null, false, expectedError);
        this.testErrorCloudEventEmitted(requestData, null, true, expectedError);
        this.testErrorCloudEventEmitted(requestData, false, null, expectedError);
        this.testErrorCloudEventEmitted(requestData, false, false, expectedError);
        this.testErrorCloudEventEmitted(requestData, false, true, expectedError);
        this.testErrorCloudEventEmitted(requestData, true, null, expectedError);
        this.testErrorCloudEventEmitted(requestData, true, false, expectedError);
        this.testErrorCloudEventEmitted(requestData, true, true, expectedError);
    }

    private static class RequestData {
        private final String modelName;
        private final String modelNamespace;
        private final String decision;
        private final String data;

        public RequestData(String modelName, String modelNamespace, String decision, String data) {
            this.modelName = modelName;
            this.modelNamespace = modelNamespace;
            this.decision = decision;
            this.data = data;
        }

        public String getModelName() {
            return this.modelName;
        }

        public String getModelNamespace() {
            return this.modelNamespace;
        }

        public String getDecision() {
            return this.decision;
        }

        public String getData() {
            return this.data;
        }
    }

    @FunctionalInterface
    private static interface TriConsumer<T, U, V> {
        public void accept(T var1, U var2, V var3);
    }
}

