/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event.cloudevents.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventExtension;
import io.cloudevents.CloudEventExtensions;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.core.provider.ExtensionProvider;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.kogito.event.AbstractDataEvent;
import org.kie.kogito.event.cloudevents.extension.KogitoExtension;
import org.kie.kogito.event.cloudevents.utils.CloudEventUtils;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

class CloudEventUtilsTest {
    private static final String TEST_DATA = "this-is-some-test-data";
    private static final Class<String> TEST_DATA_CLASS = String.class;
    private static final String TEST_ID = "acacfa12-5520-419a-91c4-05a57676dd8b";
    private static final String TEST_SERVICE_URL = "http://test-host";
    private static final String TEST_URI_STRING = "http://test-host/test-endpoint";
    private static final URI TEST_URI = URI.create("http://test-host/test-endpoint");
    private static final String TEST_SUBJECT = "test-subject";
    private static final String TEST_DECISION_MODEL_NAME = "testDecisionModel";
    private static final String TEST_DECISION_MODEL_NAMESPACE = "http://test-decision-model-namespace";
    private static final String TEST_DECISION_SERVICE_NAME = "testDecisionService";
    private static final URI TEST_DECISION_URI_UNKNOWN = URI.create(CloudEventUtils.UNKNOWN_SOURCE_URI_STRING);
    private static final URI TEST_DECISION_URI_ONLY_SERVICE = URI.create("http://test-host");
    private static final URI TEST_DECISION_URI_SERVICE_AND_MODEL = URI.create("http://test-host/testDecisionModel");
    private static final URI TEST_DECISION_URI_FULL = URI.create("http://test-host/testDecisionModel/testDecisionService");
    private static final CloudEvent TEST_CLOUDEVENT = ((io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withType(TEST_DATA_CLASS.getName()).withId("acacfa12-5520-419a-91c4-05a57676dd8b").withSource(TEST_URI).withData(String.format("\"%s\"", "this-is-some-test-data").getBytes())).build();
    private static final String TEST_CORRECT_JSON = "{  \"specversion\":\"1.0\",  \"id\":\"acacfa12-5520-419a-91c4-05a57676dd8b\",  \"source\":\"http://test-host/test-endpoint\",  \"type\":\"" + TEST_DATA_CLASS.getName() + "\",  \"data\":\"this-is-some-test-data\"}";
    private static final String TEST_MALFORMED_JSON = "not-a-json-serialized-cloudevent";
    private static final String TEST_EXCEPTION_MESSAGE = "Mocked parse error";
    private static final KogitoExtension TEST_EXTENSION = new KogitoExtension();

    CloudEventUtilsTest() {
    }

    @BeforeAll
    static void setupExtension() {
        KogitoExtension.register();
        TEST_EXTENSION.setDmnModelName(TEST_DECISION_MODEL_NAME);
        TEST_EXTENSION.setDmnModelNamespace(TEST_DECISION_MODEL_NAMESPACE);
        TEST_EXTENSION.setDmnEvaluateDecision(TEST_DECISION_SERVICE_NAME);
    }

    @Test
    void testBuildDecisionSource() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)TEST_DECISION_URI_UNKNOWN, (Object)CloudEventUtils.buildDecisionSource(null));
        org.junit.jupiter.api.Assertions.assertEquals((Object)TEST_DECISION_URI_UNKNOWN, (Object)CloudEventUtils.buildDecisionSource((String)""));
        org.junit.jupiter.api.Assertions.assertEquals((Object)TEST_DECISION_URI_UNKNOWN, (Object)CloudEventUtils.buildDecisionSource(null, null));
        org.junit.jupiter.api.Assertions.assertEquals((Object)TEST_DECISION_URI_UNKNOWN, (Object)CloudEventUtils.buildDecisionSource((String)"", (String)""));
        org.junit.jupiter.api.Assertions.assertEquals((Object)TEST_DECISION_URI_UNKNOWN, (Object)CloudEventUtils.buildDecisionSource(null, null, null));
        org.junit.jupiter.api.Assertions.assertEquals((Object)TEST_DECISION_URI_UNKNOWN, (Object)CloudEventUtils.buildDecisionSource((String)"", (String)"", (String)""));
        org.junit.jupiter.api.Assertions.assertEquals((Object)TEST_DECISION_URI_ONLY_SERVICE, (Object)CloudEventUtils.buildDecisionSource((String)TEST_SERVICE_URL));
        org.junit.jupiter.api.Assertions.assertEquals((Object)TEST_DECISION_URI_ONLY_SERVICE, (Object)CloudEventUtils.buildDecisionSource((String)TEST_SERVICE_URL, null));
        org.junit.jupiter.api.Assertions.assertEquals((Object)TEST_DECISION_URI_ONLY_SERVICE, (Object)CloudEventUtils.buildDecisionSource((String)TEST_SERVICE_URL, (String)""));
        org.junit.jupiter.api.Assertions.assertEquals((Object)TEST_DECISION_URI_ONLY_SERVICE, (Object)CloudEventUtils.buildDecisionSource((String)TEST_SERVICE_URL, null, null));
        org.junit.jupiter.api.Assertions.assertEquals((Object)TEST_DECISION_URI_ONLY_SERVICE, (Object)CloudEventUtils.buildDecisionSource((String)TEST_SERVICE_URL, (String)"", (String)""));
        org.junit.jupiter.api.Assertions.assertEquals((Object)TEST_DECISION_URI_SERVICE_AND_MODEL, (Object)CloudEventUtils.buildDecisionSource((String)TEST_SERVICE_URL, (String)TEST_DECISION_MODEL_NAME));
        org.junit.jupiter.api.Assertions.assertEquals((Object)TEST_DECISION_URI_SERVICE_AND_MODEL, (Object)CloudEventUtils.buildDecisionSource((String)TEST_SERVICE_URL, (String)TEST_DECISION_MODEL_NAME, null));
        org.junit.jupiter.api.Assertions.assertEquals((Object)TEST_DECISION_URI_SERVICE_AND_MODEL, (Object)CloudEventUtils.buildDecisionSource((String)TEST_SERVICE_URL, (String)TEST_DECISION_MODEL_NAME, (String)""));
        org.junit.jupiter.api.Assertions.assertEquals((Object)TEST_DECISION_URI_FULL, (Object)CloudEventUtils.buildDecisionSource((String)TEST_SERVICE_URL, (String)TEST_DECISION_MODEL_NAME, (String)TEST_DECISION_SERVICE_NAME));
    }

    @Test
    void testBuildSuccess() {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)CloudEventUtils.build((String)TEST_ID, (URI)TEST_URI, (Object)TEST_DATA, TEST_DATA_CLASS).isPresent());
    }

    @Test
    void testBuildFailure() throws Exception {
        CloudEventUtilsTest.runWithMockedCloudEventUtilsMapper(() -> org.junit.jupiter.api.Assertions.assertFalse((boolean)CloudEventUtils.build((String)TEST_ID, (URI)TEST_URI, (Object)TEST_DATA, TEST_DATA_CLASS).isPresent()));
    }

    @Test
    void testBuildWithExtensionSuccess() {
        Optional optCE = CloudEventUtils.build((String)TEST_ID, (URI)TEST_URI, (String)TEST_DATA_CLASS.getSimpleName(), (String)TEST_SUBJECT, (Object)TEST_DATA, (CloudEventExtension[])new CloudEventExtension[]{TEST_EXTENSION});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)optCE.isPresent());
        org.junit.jupiter.api.Assertions.assertEquals((Object)TEST_EXTENSION, (Object)ExtensionProvider.getInstance().parseExtension(KogitoExtension.class, (CloudEventExtensions)optCE.get()));
    }

    @Test
    void testBuildWithExtensionFailure() throws Exception {
        CloudEventUtilsTest.runWithMockedCloudEventUtilsMapper(() -> org.junit.jupiter.api.Assertions.assertFalse((boolean)CloudEventUtils.build((String)TEST_ID, (URI)TEST_URI, (String)TEST_DATA_CLASS.getSimpleName(), (String)TEST_SUBJECT, (Object)TEST_DATA, (CloudEventExtension[])new CloudEventExtension[]{TEST_EXTENSION}).isPresent()));
    }

    @Test
    void testDecodeDataSuccess() {
        Optional optData = CloudEventUtils.decodeData((CloudEvent)TEST_CLOUDEVENT, String.class);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)optData.isPresent());
        org.junit.jupiter.api.Assertions.assertEquals((Object)TEST_DATA, optData.get());
    }

    @Test
    void testDecodeDataFailure() {
        Optional optData = CloudEventUtils.decodeData((CloudEvent)TEST_CLOUDEVENT, Integer.class);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)optData.isPresent());
    }

    @Test
    void testEncodeSuccess() {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)CloudEventUtils.encode((CloudEvent)TEST_CLOUDEVENT).isPresent());
        System.out.println((String)CloudEventUtils.encode((CloudEvent)TEST_CLOUDEVENT).get());
    }

    @Test
    void testEncodeFailure() throws Exception {
        CloudEventUtilsTest.runWithMockedCloudEventUtilsMapper(() -> org.junit.jupiter.api.Assertions.assertFalse((boolean)CloudEventUtils.encode((CloudEvent)TEST_CLOUDEVENT).isPresent()));
    }

    @Test
    void testDecodeSuccess() {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)CloudEventUtils.decode((String)TEST_CORRECT_JSON).isPresent());
    }

    @Test
    void testDecodeFailure() {
        org.junit.jupiter.api.Assertions.assertFalse((boolean)CloudEventUtils.decode((String)TEST_MALFORMED_JSON).isPresent());
    }

    @Test
    void testUrlEncodedStringFromSuccess() {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)CloudEventUtils.urlEncodedStringFrom((String)TEST_URI_STRING).isPresent());
    }

    @Test
    void testUrlEncodedStringFromFailure() throws Exception {
        try (MockedStatic mockedStaticURLEncoder = Mockito.mockStatic(URLEncoder.class);){
            mockedStaticURLEncoder.when(() -> URLEncoder.encode((String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class))).thenThrow(new Throwable[]{new UnsupportedEncodingException()});
            org.junit.jupiter.api.Assertions.assertFalse((boolean)CloudEventUtils.urlEncodedStringFrom((String)TEST_URI_STRING).isPresent());
        }
    }

    @Test
    void testUrlEncodedURIFromSuccess() {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)CloudEventUtils.urlEncodedURIFrom((String)TEST_URI_STRING).isPresent());
    }

    @Test
    void testUrlEncodedURIFromFailure() {
        try (MockedStatic mockedStaticURLEncoder = Mockito.mockStatic(URI.class);){
            mockedStaticURLEncoder.when(() -> URI.create((String)ArgumentMatchers.any(String.class))).thenThrow(new Throwable[]{new IllegalArgumentException()});
            org.junit.jupiter.api.Assertions.assertFalse((boolean)CloudEventUtils.urlEncodedURIFrom((String)TEST_URI_STRING).isPresent());
        }
    }

    @Test
    void testLocalDate() throws JsonProcessingException {
        LocalDate localDate = LocalDate.of(2021, 12, 21);
        String marshalled = CloudEventUtils.Mapper.mapper().writeValueAsString((Object)localDate);
        LocalDate unmarshalled = (LocalDate)CloudEventUtils.Mapper.mapper().readValue(marshalled, LocalDate.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)localDate, (Object)unmarshalled);
    }

    private static ObjectMapper getFailingMockedObjectMapper() throws Exception {
        ObjectMapper mockedMapper = (ObjectMapper)Mockito.mock(ObjectMapper.class);
        Mockito.when((Object)mockedMapper.writeValueAsBytes(ArgumentMatchers.any())).thenThrow(new Throwable[]{new JsonProcessingException(TEST_EXCEPTION_MESSAGE){}});
        Mockito.when((Object)mockedMapper.writeValueAsString(ArgumentMatchers.any())).thenThrow(new Throwable[]{new JsonProcessingException(TEST_EXCEPTION_MESSAGE){}});
        return mockedMapper;
    }

    private static void runWithMockedCloudEventUtilsMapper(Runnable runnable) throws Exception {
        try (MockedStatic mockedStaticMapper = Mockito.mockStatic(CloudEventUtils.Mapper.class);){
            ObjectMapper mockedMapper = CloudEventUtilsTest.getFailingMockedObjectMapper();
            mockedStaticMapper.when(CloudEventUtils.Mapper::mapper).thenReturn((Object)mockedMapper);
            runnable.run();
        }
    }

    @Test
    void testGetAttribute() {
        AbstractDataEvent event = new AbstractDataEvent("TestType", "source", null, "kogitoProcessInstanceId", "kogitoRootProcessId", "kogitoProcessId", "kogitoRootProcessId", "kogitoAddons"){};
        Assertions.assertThat((Object)CloudEventUtils.getAttribute((String)"type", (Object)event)).isEqualTo((Object)"TestType");
        Assertions.assertThat((Object)CloudEventUtils.getAttribute((String)"source", (Object)event)).isInstanceOf(URI.class);
        Assertions.assertThat((Object)CloudEventUtils.getAttribute((String)"data", (Object)event)).isNull();
        Assertions.assertThat((Object)CloudEventUtils.getAttribute((String)"wrongValue", (Object)event)).isNull();
    }
}

