/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event.cloudevents.extension;

import java.util.Collections;
import org.kie.kogito.correlation.CompositeCorrelation;
import org.kie.kogito.event.cloudevents.extension.KogitoProcessExtension;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;

public class ProcessMeta
extends KogitoProcessExtension {
    public static ProcessMeta fromKogitoWorkItem(KogitoWorkItem kogitoWorkItem) {
        return ProcessMeta.fromKogitoProcessInstance(kogitoWorkItem.getProcessInstance());
    }

    public static ProcessMeta fromKogitoProcessInstance(KogitoProcessInstance pi) {
        ProcessMeta meta = new ProcessMeta();
        if (pi != null) {
            meta.setKogitoProcessInstanceId(pi.getStringId());
            meta.setKogitoProcessInstanceVersion(pi.getProcess().getVersion());
            meta.setKogitoParentProcessinstanceId(pi.getParentProcessInstanceId());
            meta.setKogitoRootProcessInstanceId(pi.getRootProcessInstanceId());
            meta.setKogitoProcessId(pi.getProcessId());
            meta.setKogitoRootProcessId(pi.getRootProcessId());
            meta.setKogitoProcessInstanceState(ProcessMeta.fromState(pi.getState()));
            meta.setKogitoReferenceId(pi.getReferenceId());
            meta.setKogitoBusinessKey(pi.getBusinessKey());
            meta.setKogitoProcessType(pi.getProcess().getType());
            if (pi.unwrap() != null) {
                pi.unwrap().correlation().map(c -> c instanceof CompositeCorrelation ? ((CompositeCorrelation)c).getValue() : Collections.singleton(c)).ifPresent(correlations -> correlations.forEach(c -> meta.addExtension(c.getKey(), c.asString())));
            }
        }
        return meta;
    }

    private static String fromState(int state) {
        switch (state) {
            case 3: {
                return "Aborted";
            }
            case 1: {
                return "Active";
            }
            case 2: {
                return "Completed";
            }
            case 5: {
                return "Error";
            }
            case 0: {
                return "Pending";
            }
            case 4: {
                return "Suspended";
            }
        }
        return null;
    }
}

