/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event.process;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.kie.kogito.event.process.MilestoneEventBody;
import org.kie.kogito.event.process.NodeInstanceEventBody;
import org.kie.kogito.event.process.ProcessErrorEventBody;

public class ProcessInstanceEventBody {
    public static final String ID_META_DATA = "kogito.processinstance.id";
    public static final String VERSION_META_DATA = "kogito.processinstance.version";
    public static final String PARENT_ID_META_DATA = "kogito.processinstance.parentInstanceId";
    public static final String ROOT_ID_META_DATA = "kogito.processinstance.rootInstanceId";
    public static final String PROCESS_ID_META_DATA = "kogito.processinstance.processId";
    public static final String PROCESS_TYPE_META_DATA = "kogito.processinstance.processType";
    public static final String ROOT_PROCESS_ID_META_DATA = "kogito.processinstance.rootProcessId";
    public static final String STATE_META_DATA = "kogito.processinstance.state";
    private String id;
    private String version;
    private String parentInstanceId;
    private String rootInstanceId;
    private String processId;
    private String processType;
    private String rootProcessId;
    private String processName;
    private Date startDate;
    private Date endDate;
    private Integer state;
    private String businessKey;
    private Set<NodeInstanceEventBody> nodeInstances = new LinkedHashSet<NodeInstanceEventBody>();
    private Map<String, Object> variables;
    private ProcessErrorEventBody error;
    private Set<String> roles;
    private Set<MilestoneEventBody> milestones = Collections.emptySet();

    private ProcessInstanceEventBody() {
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public String getParentInstanceId() {
        return this.parentInstanceId;
    }

    public String getRootInstanceId() {
        return this.rootInstanceId;
    }

    public String getProcessId() {
        return this.processId;
    }

    public String getProcessType() {
        return this.processType;
    }

    public String getRootProcessId() {
        return this.rootProcessId;
    }

    public String getProcessName() {
        return this.processName;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public Integer getState() {
        return this.state;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public ProcessErrorEventBody getError() {
        return this.error;
    }

    public Set<NodeInstanceEventBody> getNodeInstances() {
        return this.nodeInstances;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public Set<MilestoneEventBody> getMilestones() {
        return this.milestones;
    }

    public Builder update() {
        return new Builder(this);
    }

    public Map<String, String> metaData() {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put(ID_META_DATA, this.id);
        metadata.put(VERSION_META_DATA, this.version);
        metadata.put(PARENT_ID_META_DATA, this.parentInstanceId);
        metadata.put(ROOT_ID_META_DATA, this.rootInstanceId);
        metadata.put(PROCESS_ID_META_DATA, this.processId);
        metadata.put(PROCESS_TYPE_META_DATA, this.processType);
        metadata.put(ROOT_PROCESS_ID_META_DATA, this.rootProcessId);
        metadata.put(STATE_META_DATA, String.valueOf(this.state));
        return metadata;
    }

    public String toString() {
        return "ProcessInstanceEventBody{id='" + this.id + "', version='" + this.version + "', parentInstanceId='" + this.parentInstanceId + "', rootInstanceId='" + this.rootInstanceId + "', processId='" + this.processId + "', processType='" + this.processType + "', rootProcessId='" + this.rootProcessId + "', processName='" + this.processName + "', startDate=" + this.startDate + ", endDate=" + this.endDate + ", state=" + this.state + ", businessKey='" + this.businessKey + "', nodeInstances=" + this.nodeInstances + ", variables=" + this.variables + ", error=" + this.error + ", roles=" + this.roles + ", milestones=" + this.milestones + "}";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessInstanceEventBody other = (ProcessInstanceEventBody)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public static Builder create() {
        return new Builder(new ProcessInstanceEventBody());
    }

    public static class Builder {
        private ProcessInstanceEventBody instance;

        public Builder(ProcessInstanceEventBody instance) {
            this.instance = instance;
        }

        public Builder id(String id) {
            this.instance.id = id;
            return this;
        }

        public Builder version(String version) {
            this.instance.version = version;
            return this;
        }

        public Builder parentInstanceId(String parentInstanceId) {
            this.instance.parentInstanceId = parentInstanceId;
            return this;
        }

        public Builder rootInstanceId(String rootInstanceId) {
            this.instance.rootInstanceId = rootInstanceId;
            return this;
        }

        public Builder processId(String processId) {
            this.instance.processId = processId;
            return this;
        }

        public Builder processType(String processType) {
            this.instance.processType = processType;
            return this;
        }

        public Builder rootProcessId(String rootProcessId) {
            this.instance.rootProcessId = rootProcessId;
            return this;
        }

        public Builder processName(String processName) {
            this.instance.processName = processName;
            return this;
        }

        public Builder startDate(Date date) {
            this.instance.startDate = date;
            return this;
        }

        public Builder endDate(Date date) {
            this.instance.endDate = date;
            return this;
        }

        public Builder state(Integer state) {
            this.instance.state = state;
            return this;
        }

        public Builder businessKey(String businessKey) {
            this.instance.businessKey = businessKey;
            return this;
        }

        public Builder nodeInstance(NodeInstanceEventBody nodeInstance) {
            this.instance.nodeInstances.add(nodeInstance);
            return this;
        }

        public Builder variables(Map<String, Object> variables) {
            this.instance.variables = variables;
            return this;
        }

        public Builder error(ProcessErrorEventBody error) {
            this.instance.error = error;
            return this;
        }

        public Builder roles(String ... roles) {
            this.instance.roles = Set.of(roles);
            return this;
        }

        public Builder milestones(Set<MilestoneEventBody> milestones) {
            this.instance.milestones = milestones;
            return this;
        }

        public ProcessInstanceEventBody build() {
            return this.instance;
        }
    }
}

