/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event.cloudevents.extension;

import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventExtensions;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.core.provider.ExtensionProvider;
import java.net.URI;
import java.util.Collection;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.kogito.event.cloudevents.extension.KogitoProcessExtension;

class KogitoProcessExtensionTest {
    KogitoProcessExtensionTest() {
    }

    @BeforeAll
    static void setupTest() {
        ExtensionProvider.getInstance().registerExtension(KogitoProcessExtension.class, KogitoProcessExtension::new);
    }

    @Test
    void verifyKogitoExtensionCanBeRead() {
        KogitoProcessExtension kpe = new KogitoProcessExtension();
        kpe.readFrom((CloudEventExtensions)this.getExampleCloudEvent());
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)kpe.getValue("kogitoprocrefid")).isNotNull()).isInstanceOf(String.class)).isEqualTo((Object)"12345");
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)kpe.getValue("kogitoprocid")).isNotNull()).isInstanceOf(String.class)).isEqualTo((Object)"super_process");
        Assertions.assertThat((String)((String)kpe.getValue("kogitoprocinstanceid"))).isBlank();
        Assertions.assertThat((String)((String)kpe.getValue("kogitoprocist"))).isBlank();
        Assertions.assertThat((String)((String)kpe.getValue("kogitorootprociid"))).isBlank();
        Assertions.assertThat((String)((String)kpe.getValue("kogitorootprocid"))).isBlank();
        Assertions.assertThat((String)((String)kpe.getValue("kogitoparentprociid"))).isBlank();
        Assertions.assertThat((String)((String)kpe.getValue("kogitoaddons"))).isBlank();
    }

    @Test
    void verifyKeysAreSet() {
        KogitoProcessExtension kpe = (KogitoProcessExtension)ExtensionProvider.getInstance().parseExtension(KogitoProcessExtension.class, (CloudEventExtensions)this.getExampleCloudEvent());
        Assertions.assertThat((Object)kpe).isNotNull();
        Assertions.assertThat((Collection)kpe.getKeys()).isNotNull();
        Assertions.assertThat((Collection)kpe.getKeys()).isNotEmpty();
    }

    private CloudEvent getExampleCloudEvent() {
        return ((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withId(UUID.randomUUID().toString()).withType("example.demo").withSource(URI.create("http://example.com")).withData("application/json", "{}".getBytes())).withExtension("kogitoprocrefid", "12345")).withExtension("kogitoprocid", "super_process")).build();
    }
}

