/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.events.spring;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.text.DateFormat;
import java.util.Collection;
import java.util.TimeZone;
import org.kie.kogito.event.DataEvent;
import org.kie.kogito.event.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Component;

@Component
public class KafkaEventPublisher
implements EventPublisher {
    private static final String PI_TOPIC_NAME = "kogito-processinstances-events";
    private static final String UI_TOPIC_NAME = "kogito-usertaskinstances-events";
    private static final String VI_TOPIC_NAME = "kogito-variables-events";
    private static final Logger logger = LoggerFactory.getLogger(KafkaEventPublisher.class);
    private ObjectMapper json = new ObjectMapper();
    @Autowired
    private KafkaTemplate<String, String> eventsEmitter;
    @Value(value="${kogito.events.processinstances.enabled:true}")
    private boolean processInstancesEvents;
    @Value(value="${kogito.events.usertasks.enabled:true}")
    private boolean userTasksEvents;
    @Value(value="${kogito.events.variables.enabled:true}")
    private boolean variablesEvents;

    public KafkaEventPublisher() {
        this.json.setDateFormat((DateFormat)new StdDateFormat().withColonInTimeZone(true).withTimeZone(TimeZone.getDefault()));
    }

    public void publish(DataEvent<?> event) {
        if (event.getType().equals("ProcessInstanceEvent") && this.processInstancesEvents) {
            this.publishToTopic(event, this.eventsEmitter, PI_TOPIC_NAME);
        } else if (event.getType().equals("UserTaskInstanceEvent") && this.userTasksEvents) {
            this.publishToTopic(event, this.eventsEmitter, UI_TOPIC_NAME);
        } else if (event.getType().equals("VariableInstanceEvent") && this.variablesEvents) {
            this.publishToTopic(event, this.eventsEmitter, VI_TOPIC_NAME);
        } else {
            logger.warn("Unknown type of event '{}', ignoring", (Object)event.getType());
        }
    }

    public void publish(Collection<DataEvent<?>> events) {
        for (DataEvent<?> event : events) {
            this.publish(event);
        }
    }

    protected void publishToTopic(DataEvent<?> event, KafkaTemplate<String, String> emitter, String topic) {
        logger.debug("About to publish event {} to Kafka topic {}", event, (Object)topic);
        try {
            String eventString = this.json.writeValueAsString(event);
            logger.debug("Event payload '{}'", (Object)eventString);
            this.eventsEmitter.send(topic, (Object)eventString);
            logger.debug("Successfully published event {} to topic {}", event, (Object)topic);
        }
        catch (Exception e) {
            logger.error("Error while publishing event to Kafka topic {} for event {}", new Object[]{topic, event, e});
        }
    }
}

