/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jackson.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;

public class MergeUtils {
    public static Object merge(JsonNode src, JsonNode dest) {
        if (dest.isArray()) {
            return ((ArrayNode)dest).add(src);
        }
        ObjectReader reader = ObjectMapperFactory.get().readerForUpdating((Object)dest);
        try {
            if (src.isArray()) {
                ObjectNode node = (ObjectNode)reader.createObjectNode();
                node.set("response", src);
                return reader.readValue((JsonNode)node);
            }
            return reader.readValue(src);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to merge input model and JSON response: " + src, e);
        }
    }

    private MergeUtils() {
    }
}

