/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jackson.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.util.Arrays;
import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.jackson.utils.JsonObjectUtils;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;
import org.kie.kogito.jackson.utils.Person;

public class JsonObjectUtilsTest {
    @Test
    void testPojo() {
        Assertions.assertEquals((Object)ObjectMapperFactory.get().createObjectNode().put("name", "javierito"), (Object)JsonObjectUtils.fromValue((Object)new Person("javierito")));
    }

    @Test
    void testArrayOfPojo() {
        Assertions.assertEquals((Object)ObjectMapperFactory.get().createArrayNode().add((JsonNode)ObjectMapperFactory.get().createObjectNode().put("name", "javierito")).add((JsonNode)ObjectMapperFactory.get().createObjectNode().put("name", "fulanito")), (Object)JsonObjectUtils.fromValue(Arrays.asList(new Person("javierito"), new Person("fulanito"))));
    }

    @Test
    void testJavaArray() {
        Assertions.assertEquals(Arrays.asList(Collections.singletonMap("name", "javierito"), Collections.singletonMap("name", "fulanito")), (Object)JsonObjectUtils.toJavaValue((JsonNode)ObjectMapperFactory.get().createArrayNode().add((JsonNode)ObjectMapperFactory.get().createObjectNode().put("name", "javierito")).add((JsonNode)ObjectMapperFactory.get().createObjectNode().put("name", "fulanito"))));
    }

    @Test
    void testJavaObject() {
        Assertions.assertEquals(Collections.singletonMap("name", "javierito"), (Object)JsonObjectUtils.toJavaValue((JsonNode)ObjectMapperFactory.get().createObjectNode().put("name", "javierito")));
    }

    @Test
    void testNullObject() {
        Assertions.assertNull((Object)JsonObjectUtils.toJavaValue((JsonNode)NullNode.getInstance()));
    }

    @Test
    void testJavaInt() {
        Assertions.assertEquals((Object)5, (Object)JsonObjectUtils.toJavaValue((JsonNode)new IntNode(5)));
    }

    @Test
    void testJavaDouble() {
        Assertions.assertEquals((Object)5.0, (Object)JsonObjectUtils.toJavaValue((JsonNode)new DoubleNode(5.0)));
    }

    @Test
    void testJavaFloat() {
        Assertions.assertEquals((Object)Float.valueOf(5.0f), (Object)JsonObjectUtils.toJavaValue((JsonNode)new FloatNode(5.0f)));
    }

    @Test
    void testJavaByteArray() {
        byte[] bytes = new byte[]{1, 2, 3, 4};
        Assertions.assertArrayEquals((byte[])bytes, (byte[])((byte[])JsonObjectUtils.toJavaValue((JsonNode)BinaryNode.valueOf((byte[])bytes))));
    }
}

