/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jackson.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MergeUtils {
    public static JsonNode merge(JsonNode src, JsonNode target) {
        return MergeUtils.merge(src, target, false);
    }

    public static JsonNode merge(JsonNode src, JsonNode target, boolean skipDuplicates) {
        if (target == null || target.isNull()) {
            return src;
        }
        if (target.isArray()) {
            return MergeUtils.mergeArray(src, (ArrayNode)target, skipDuplicates);
        }
        if (target.isObject()) {
            return MergeUtils.mergeObject(src, (ObjectNode)target, skipDuplicates);
        }
        if (src.isArray()) {
            ArrayNode srcArray = (ArrayNode)src;
            MergeUtils.insert(srcArray, target, MergeUtils.getExistingNodes(srcArray, skipDuplicates));
        }
        return src;
    }

    private static ObjectNode mergeObject(JsonNode src, ObjectNode target, boolean skipDuplicates) {
        if (src.isObject()) {
            Iterator mergedIterator = src.fields();
            while (mergedIterator.hasNext()) {
                Map.Entry entry = (Map.Entry)mergedIterator.next();
                JsonNode found = target.get((String)entry.getKey());
                target.set((String)entry.getKey(), found != null ? MergeUtils.merge((JsonNode)entry.getValue(), found, skipDuplicates) : (JsonNode)entry.getValue());
            }
        } else if (!src.isNull()) {
            target.set("response", src);
        }
        return target;
    }

    private static JsonNode mergeArray(JsonNode src, ArrayNode target, boolean skipDuplicates) {
        if (src != target) {
            Set<JsonNode> existingNodes = MergeUtils.getExistingNodes(target, skipDuplicates);
            if (src.isArray()) {
                ((ArrayNode)src).forEach(node -> MergeUtils.add(target, node, existingNodes));
            } else {
                MergeUtils.add(target, src, existingNodes);
            }
        }
        return target;
    }

    private static void add(ArrayNode array, JsonNode node, Set<JsonNode> existingNodes) {
        if (!existingNodes.contains(node)) {
            array.add(node);
        }
    }

    private static void insert(ArrayNode array, JsonNode node, Set<JsonNode> existingNodes) {
        if (!existingNodes.contains(node)) {
            array.insert(0, node);
        }
    }

    private static Set<JsonNode> getExistingNodes(ArrayNode arrayNode, boolean skipDuplicates) {
        Set<JsonNode> existingNodes = Collections.emptySet();
        if (skipDuplicates) {
            existingNodes = new HashSet<JsonNode>();
            arrayNode.forEach(existingNodes::add);
        }
        return existingNodes;
    }

    private MergeUtils() {
    }
}

