/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jackson.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.jackson.utils.JsonNodeVisitor;
import org.kie.kogito.jackson.utils.JsonObjectUtils;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;

public class JsonNodeVisitorTest {
    @Test
    void testSimpleObjectNodeVisitor() {
        ObjectNode source = ObjectMapperFactory.get().createObjectNode().put("name", "no javierito");
        Assertions.assertEquals((Object)ObjectMapperFactory.get().createObjectNode().put("name", "javierito"), (Object)JsonNodeVisitor.transformTextNode((JsonNode)source, n -> JsonObjectUtils.fromValue((Object)"javierito")));
    }

    @Test
    void testComplextObjectNodeVisitor() {
        ObjectNode source = (ObjectNode)ObjectMapperFactory.get().createObjectNode().set("embedded", (JsonNode)ObjectMapperFactory.get().createObjectNode().put("name", "no javierito"));
        Assertions.assertEquals((Object)ObjectMapperFactory.get().createObjectNode().set("embedded", (JsonNode)ObjectMapperFactory.get().createObjectNode().put("name", "javierito")), (Object)JsonNodeVisitor.transformTextNode((JsonNode)source, n -> JsonObjectUtils.fromValue((Object)"javierito")));
    }

    @Test
    void testArrayNodeVisitor() {
        ObjectNode source = (ObjectNode)ObjectMapperFactory.get().createObjectNode().set("embedded", (JsonNode)ObjectMapperFactory.get().createArrayNode().add((JsonNode)ObjectMapperFactory.get().createObjectNode().put("name", "no javierito")));
        Assertions.assertEquals((Object)ObjectMapperFactory.get().createObjectNode().set("embedded", (JsonNode)ObjectMapperFactory.get().createArrayNode().add((JsonNode)ObjectMapperFactory.get().createObjectNode().put("name", "javierito"))), (Object)JsonNodeVisitor.transformTextNode((JsonNode)source, n -> JsonObjectUtils.fromValue((Object)"javierito")));
    }
}

