/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jackson.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;

public class JsonObjectUtils {
    public static JsonNode fromValue(Object value) {
        if (value == null) {
            return NullNode.instance;
        }
        if (value instanceof JsonNode) {
            return (JsonNode)value;
        }
        if (value instanceof Boolean) {
            return BooleanNode.valueOf((boolean)((Boolean)value));
        }
        if (value instanceof String) {
            return new TextNode((String)value);
        }
        if (value instanceof Short) {
            return new ShortNode(((Short)value).shortValue());
        }
        if (value instanceof Integer) {
            return new IntNode(((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return new LongNode(((Long)value).longValue());
        }
        if (value instanceof Float) {
            return new FloatNode(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return new DoubleNode(((Double)value).doubleValue());
        }
        if (value instanceof BigDecimal) {
            return DecimalNode.valueOf((BigDecimal)((BigDecimal)value));
        }
        if (value instanceof BigInteger) {
            return BigIntegerNode.valueOf((BigInteger)((BigInteger)value));
        }
        if (value instanceof byte[]) {
            return BinaryNode.valueOf((byte[])((byte[])value));
        }
        if (value instanceof Iterable) {
            return JsonObjectUtils.mapToArray((Iterable)value);
        }
        if (value instanceof Map) {
            return JsonObjectUtils.mapToNode((Map)value);
        }
        return (JsonNode)ObjectMapperFactory.get().convertValue(value, JsonNode.class);
    }

    public static Object toJavaValue(JsonNode jsonNode) {
        return JsonObjectUtils.internalToJavaValue(jsonNode, node -> {
            HashMap result = new HashMap();
            node.fields().forEachRemaining(iter -> result.put((String)iter.getKey(), JsonObjectUtils.toJavaValue((JsonNode)iter.getValue())));
            return result;
        });
    }

    public static <T> T convertValue(Object obj, Class<T> returnType) {
        if (returnType.isInstance(obj)) {
            return returnType.cast(obj);
        }
        if (obj instanceof JsonNode) {
            return JsonObjectUtils.convertValue((JsonNode)obj, returnType);
        }
        return (T)ObjectMapperFactory.get().convertValue(obj, returnType);
    }

    public static <T> T convertValue(JsonNode jsonNode, Class<T> returnType) {
        Object obj = Boolean.class.isAssignableFrom(returnType) ? Boolean.valueOf(jsonNode.asBoolean()) : (Integer.class.isAssignableFrom(returnType) ? Integer.valueOf(jsonNode.asInt()) : (Double.class.isAssignableFrom(returnType) ? Double.valueOf(jsonNode.asDouble()) : (Long.class.isAssignableFrom(returnType) ? Long.valueOf(jsonNode.asLong()) : (String.class.isAssignableFrom(returnType) ? jsonNode.asText() : ObjectMapperFactory.get().convertValue((Object)jsonNode, returnType)))));
        return returnType.cast(obj);
    }

    public static Object simpleToJavaValue(JsonNode jsonNode) {
        return JsonObjectUtils.internalToJavaValue(jsonNode, node -> node);
    }

    private static Object internalToJavaValue(JsonNode jsonNode, Function<JsonNode, Object> function) {
        if (jsonNode.isNull()) {
            return null;
        }
        if (jsonNode.isTextual()) {
            return jsonNode.asText();
        }
        if (jsonNode.isBoolean()) {
            return jsonNode.asBoolean();
        }
        if (jsonNode.isInt()) {
            return jsonNode.asInt();
        }
        if (jsonNode.isDouble()) {
            return jsonNode.asDouble();
        }
        if (jsonNode.isNumber()) {
            return jsonNode.numberValue();
        }
        if (jsonNode.isArray()) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (JsonNode item : (ArrayNode)jsonNode) {
                result.add(JsonObjectUtils.internalToJavaValue(item, function));
            }
            return result;
        }
        if (jsonNode.isObject()) {
            return function.apply(jsonNode);
        }
        return ObjectMapperFactory.get().convertValue((Object)jsonNode, Object.class);
    }

    public static String toString(JsonNode node) throws JsonProcessingException {
        return ObjectMapperFactory.get().writeValueAsString((Object)node);
    }

    public static void addToNode(String name, Object value, ObjectNode dest) {
        dest.set(name, JsonObjectUtils.fromValue(value));
    }

    private static ObjectNode mapToNode(Map<String, Object> value) {
        ObjectNode objectNode = ObjectMapperFactory.get().createObjectNode();
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            JsonObjectUtils.addToNode(entry.getKey(), entry.getValue(), objectNode);
        }
        return objectNode;
    }

    private static ArrayNode mapToArray(Iterable<?> iterable) {
        return JsonObjectUtils.mapToArray(iterable, ObjectMapperFactory.get().createArrayNode());
    }

    private static ArrayNode mapToArray(Iterable<?> iterable, ArrayNode arrayNode) {
        for (Object item : iterable) {
            arrayNode.add(JsonObjectUtils.fromValue(item));
        }
        return arrayNode;
    }

    private JsonObjectUtils() {
    }
}

