/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jackson.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.internal.process.event.KogitoObjectListener;
import org.kie.kogito.jackson.utils.ArrayNodeListenerAware;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;
import org.kie.kogito.jackson.utils.ObjectNodeListenerAware;
import org.mockito.Mockito;

public class ListenerAwareTest {
    private KogitoObjectListener listener;

    @BeforeEach
    void setup() {
        this.listener = (KogitoObjectListener)Mockito.mock(KogitoObjectListener.class);
    }

    @Test
    void testObjectNodeChange() {
        ObjectNodeListenerAware node = (ObjectNodeListenerAware)ObjectMapperFactory.listenerAware().createObjectNode();
        node.addKogitoObjectListener(this.listener);
        node.put("name", "Javierito");
        ((KogitoObjectListener)Mockito.verify((Object)this.listener)).beforeValueChanged((Object)node, "name", (Object)NullNode.instance, (Object)new TextNode("Javierito"));
        ((KogitoObjectListener)Mockito.verify((Object)this.listener)).afterValueChanged((Object)node, "name", (Object)NullNode.instance, (Object)new TextNode("Javierito"));
        node.put("name", 3);
        ((KogitoObjectListener)Mockito.verify((Object)this.listener)).beforeValueChanged((Object)node, "name", (Object)new TextNode("Javierito"), (Object)new IntNode(3));
        ((KogitoObjectListener)Mockito.verify((Object)this.listener)).afterValueChanged((Object)node, "name", (Object)new TextNode("Javierito"), (Object)new IntNode(3));
        node.remove("name");
        ((KogitoObjectListener)Mockito.verify((Object)this.listener)).beforeValueChanged((Object)node, "name", (Object)new IntNode(3), (Object)NullNode.instance);
        ((KogitoObjectListener)Mockito.verify((Object)this.listener)).afterValueChanged((Object)node, "name", (Object)new IntNode(3), (Object)NullNode.instance);
    }

    @Test
    void testArrayNodeChange() {
        ArrayNodeListenerAware node = (ArrayNodeListenerAware)ObjectMapperFactory.listenerAware().createArrayNode();
        node.addKogitoObjectListener(this.listener);
        node.add("Javierito");
        ((KogitoObjectListener)Mockito.verify((Object)this.listener)).beforeValueChanged((Object)node, "[0]", (Object)NullNode.instance, (Object)new TextNode("Javierito"));
        ((KogitoObjectListener)Mockito.verify((Object)this.listener)).afterValueChanged((Object)node, "[0]", (Object)NullNode.instance, (Object)new TextNode("Javierito"));
        node.insert(1, "OtherJavierito");
        ((KogitoObjectListener)Mockito.verify((Object)this.listener)).beforeValueChanged((Object)node, "[1]", (Object)NullNode.instance, (Object)new TextNode("OtherJavierito"));
        ((KogitoObjectListener)Mockito.verify((Object)this.listener)).afterValueChanged((Object)node, "[1]", (Object)NullNode.instance, (Object)new TextNode("OtherJavierito"));
        node.set(1, "NotLikeJavierito");
        ((KogitoObjectListener)Mockito.verify((Object)this.listener)).beforeValueChanged((Object)node, "[1]", (Object)new TextNode("OtherJavierito"), (Object)new TextNode("NotLikeJavierito"));
        ((KogitoObjectListener)Mockito.verify((Object)this.listener)).afterValueChanged((Object)node, "[1]", (Object)new TextNode("OtherJavierito"), (Object)new TextNode("NotLikeJavierito"));
        node.remove(0);
        ((KogitoObjectListener)Mockito.verify((Object)this.listener)).beforeValueChanged((Object)node, "[0]", (Object)new TextNode("Javierito"), (Object)NullNode.instance);
        ((KogitoObjectListener)Mockito.verify((Object)this.listener)).afterValueChanged((Object)node, "[0]", (Object)new TextNode("Javierito"), (Object)NullNode.instance);
    }

    @Test
    void testComplexObjectNodeChange() {
        ObjectNodeListenerAware node = (ObjectNodeListenerAware)ObjectMapperFactory.listenerAware().createObjectNode();
        node.addKogitoObjectListener(this.listener);
        ObjectNode embedded = node.objectNode().put("surname", "Javierito");
        node.set("name", (JsonNode)embedded);
        ((KogitoObjectListener)Mockito.verify((Object)this.listener)).beforeValueChanged((Object)node, "name", (Object)NullNode.instance, (Object)embedded);
        ((KogitoObjectListener)Mockito.verify((Object)this.listener)).afterValueChanged((Object)node, "name", (Object)NullNode.instance, (Object)embedded);
        embedded.put("surname", "NotLikeJavierito");
        ((KogitoObjectListener)Mockito.verify((Object)this.listener)).beforeValueChanged((Object)node, "name.surname", (Object)new TextNode("Javierito"), (Object)new TextNode("NotLikeJavierito"));
        ((KogitoObjectListener)Mockito.verify((Object)this.listener)).afterValueChanged((Object)node, "name.surname", (Object)new TextNode("Javierito"), (Object)new TextNode("NotLikeJavierito"));
    }

    @Test
    void testObjectClone() {
        ObjectNode node = ObjectMapperFactory.listenerAware().createObjectNode().put("name", "Javierito");
        Assertions.assertTrue((boolean)(node instanceof ObjectNodeListenerAware));
        ObjectNode cloned = node.deepCopy();
        Assertions.assertTrue((boolean)(cloned instanceof ObjectNodeListenerAware));
        Assertions.assertNotSame((Object)node, (Object)cloned);
        Assertions.assertEquals((Object)node, (Object)cloned);
    }

    @Test
    void testArrayClone() {
        ArrayNode node = ObjectMapperFactory.listenerAware().getNodeFactory().arrayNode(2).add("Javierito");
        Assertions.assertTrue((boolean)(node instanceof ArrayNodeListenerAware));
        ArrayNode cloned = node.deepCopy();
        Assertions.assertTrue((boolean)(cloned instanceof ArrayNodeListenerAware));
        Assertions.assertNotSame((Object)node, (Object)cloned);
        Assertions.assertEquals((Object)node, (Object)cloned);
    }
}

