/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jackson.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.kie.kogito.internal.process.event.KogitoObjectListener;
import org.kie.kogito.internal.process.event.KogitoObjectListenerAware;
import org.kie.kogito.jackson.utils.ListenerAwareUtils;

public class ObjectNodeListenerAware
extends ObjectNode
implements KogitoObjectListenerAware {
    private static final long serialVersionUID = 1L;
    private transient Collection<KogitoObjectListener> listeners = new CopyOnWriteArrayList<KogitoObjectListener>();

    public ObjectNodeListenerAware(JsonNodeFactory nc) {
        super(nc);
    }

    protected ObjectNode _put(String fieldName, JsonNode value) {
        this.fireEvent(fieldName, this._children.get(fieldName), value, () -> this._children.put(fieldName, value));
        return this;
    }

    public <T extends JsonNode> T set(String propertyName, JsonNode value) {
        this.fireEvent(propertyName, this._children.get(propertyName), value, () -> this._children.put(propertyName, value));
        return (T)((Object)this);
    }

    public JsonNode remove(String propertyName) {
        JsonNode oldValue = (JsonNode)this._children.get(propertyName);
        this.fireEvent(propertyName, oldValue, this.nullNode(), () -> super.remove(propertyName));
        return oldValue;
    }

    public void addKogitoObjectListener(KogitoObjectListener listener) {
        this.listeners.add(listener);
    }

    public Collection<KogitoObjectListener> listeners() {
        return Collections.unmodifiableCollection(this.listeners);
    }

    public ObjectNode deepCopy() {
        ObjectNodeListenerAware ret = new ObjectNodeListenerAware(this._nodeFactory);
        for (Map.Entry entry : this._children.entrySet()) {
            ret._children.put((String)entry.getKey(), ((JsonNode)entry.getValue()).deepCopy());
        }
        return ret;
    }

    public void fireEvent(String propertyName, Object oldValue, Object newValue, Runnable updater) {
        super.fireEvent(propertyName, ListenerAwareUtils.handleNull(oldValue), ListenerAwareUtils.handleNull(newValue), updater);
    }
}

