/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jackson.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.util.Arrays;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.jackson.utils.JsonObjectUtils;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;
import org.kie.kogito.jackson.utils.Person;

public class JsonObjectUtilsTest {
    @Test
    void testPojo() {
        Assertions.assertThat((Iterable)JsonObjectUtils.fromValue((Object)new Person("javierito"))).isEqualTo((Object)ObjectMapperFactory.get().createObjectNode().put("name", "javierito"));
    }

    @Test
    void testArrayOfPojo() {
        Assertions.assertThat((Iterable)JsonObjectUtils.fromValue(Arrays.asList(new Person("javierito"), new Person("fulanito")))).isEqualTo((Object)ObjectMapperFactory.get().createArrayNode().add((JsonNode)ObjectMapperFactory.get().createObjectNode().put("name", "javierito")).add((JsonNode)ObjectMapperFactory.get().createObjectNode().put("name", "fulanito")));
    }

    @Test
    void testJavaArray() {
        Assertions.assertThat((Object)JsonObjectUtils.toJavaValue((JsonNode)ObjectMapperFactory.get().createArrayNode().add((JsonNode)ObjectMapperFactory.get().createObjectNode().put("name", "javierito")).add((JsonNode)ObjectMapperFactory.get().createObjectNode().put("name", "fulanito")))).isEqualTo(Arrays.asList(Collections.singletonMap("name", "javierito"), Collections.singletonMap("name", "fulanito")));
    }

    @Test
    void testJavaObject() {
        Assertions.assertThat((Object)JsonObjectUtils.toJavaValue((JsonNode)ObjectMapperFactory.get().createObjectNode().put("name", "javierito"))).isEqualTo(Collections.singletonMap("name", "javierito"));
    }

    @Test
    void testNullObject() {
        Assertions.assertThat((Object)JsonObjectUtils.toJavaValue((JsonNode)NullNode.getInstance())).isNull();
    }

    @Test
    void testJavaInt() {
        Assertions.assertThat((Object)JsonObjectUtils.toJavaValue((JsonNode)new IntNode(5))).isEqualTo((Object)5);
    }

    @Test
    void testJavaDouble() {
        Assertions.assertThat((Object)JsonObjectUtils.toJavaValue((JsonNode)new DoubleNode(5.0))).isEqualTo((Object)5.0);
    }

    @Test
    void testJavaFloat() {
        Assertions.assertThat((Object)JsonObjectUtils.toJavaValue((JsonNode)new FloatNode(5.0f))).isEqualTo((Object)Float.valueOf(5.0f));
    }

    @Test
    void testJavaByteArray() {
        byte[] bytes = new byte[]{1, 2, 3, 4};
        Assertions.assertThat((byte[])((byte[])JsonObjectUtils.toJavaValue((JsonNode)BinaryNode.valueOf((byte[])bytes)))).isEqualTo((Object)bytes);
    }
}

