/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.expr.jsonpath;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import org.kie.kogito.jackson.utils.JsonObjectUtils;
import org.kie.kogito.process.workitems.impl.expr.ParsedExpression;
import org.kie.kogito.serverless.workflow.utils.ExpressionHandlerUtils;

public class JsonPathParsedExpression
implements ParsedExpression {
    private static final Configuration jsonPathConfig = Configuration.builder().mappingProvider((MappingProvider)new JacksonMappingProvider()).jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider()).build();
    private String expr;
    private ParseContext jsonPath = JsonPath.using((Configuration)jsonPathConfig);

    public JsonPathParsedExpression(String expr) {
        this.expr = expr;
    }

    public <T> T eval(Object context, Class<T> returnClass) {
        DocumentContext parsedContext = this.jsonPath.parse(context);
        if (String.class.isAssignableFrom(returnClass)) {
            StringBuilder sb = new StringBuilder();
            for (String part : this.expr.split("((?=\\$))")) {
                sb.append((String)parsedContext.read(part, String.class, new Predicate[0]));
            }
            return (T)sb.toString();
        }
        Object result = parsedContext.read(this.expr, new Predicate[0]);
        return (T)(Boolean.class.isAssignableFrom(returnClass) && result instanceof ArrayNode ? Boolean.valueOf(!((ArrayNode)result).isEmpty()) : jsonPathConfig.mappingProvider().map(result, returnClass, jsonPathConfig));
    }

    public void assign(Object context, Object value) {
        JsonObjectUtils.addToNode((String)((String)ExpressionHandlerUtils.fallbackVarToName((String)this.expr).orElseThrow(() -> new IllegalArgumentException("Cannot find a valid variable name for expression " + this.expr))), (Object)value, (ObjectNode)((ObjectNode)context));
    }
}

