/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jsonpath;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.util.regex.Pattern;

public class JsonPathUtils {
    private static final Pattern jsonPathRegexPattern = Pattern.compile("^((\\$\\[).*|(\\$\\.).*)");
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final Configuration jsonPathConfig = Configuration.builder().mappingProvider((MappingProvider)new JacksonMappingProvider()).jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider()).build();

    private JsonPathUtils() {
    }

    public static boolean isJsonPath(String expression) {
        return jsonPathRegexPattern.matcher(expression).matches();
    }

    static JsonNode evalExpr(Object inputModel, String expression) {
        return (JsonNode)JsonPath.using((Configuration)JsonPathUtils.getJsonPathConfig()).parse(inputModel).read(expression, JsonNode.class, new Predicate[0]);
    }

    static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    static Configuration getJsonPathConfig() {
        return jsonPathConfig;
    }
}

