/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jsonpath;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.Iterator;
import org.kie.kogito.jsonpath.JsonPathUtils;
import org.kie.kogito.process.workitems.impl.ExpressionWorkItemResolver;

public class ObjectJsonPathResolver
extends ExpressionWorkItemResolver {
    public ObjectJsonPathResolver(String jsonPathExpr, String paramName) {
        super(jsonPathExpr, paramName);
    }

    protected Object evalExpression(Object inputModel) {
        return this.readValue(JsonPathUtils.evalExpr(inputModel, this.expression));
    }

    private Object readValue(JsonNode node) {
        switch (node.getNodeType()) {
            case NUMBER: {
                if (node.isInt()) {
                    return node.asInt();
                }
                if (node.isLong()) {
                    return node.asLong();
                }
                return node.asDouble();
            }
            case BOOLEAN: {
                return node.asBoolean();
            }
            case NULL: {
                return null;
            }
            case ARRAY: {
                return this.readArray((ArrayNode)node);
            }
            case STRING: {
                return node.asText();
            }
        }
        return node;
    }

    private Object readArray(ArrayNode node) {
        Iterator elements = node.elements();
        ArrayList<Object> result = new ArrayList<Object>();
        while (elements.hasNext()) {
            result.add(this.readValue((JsonNode)elements.next()));
        }
        return result;
    }
}

