/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.maven.plugin;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.SignatureAttribute;
import javassist.bytecode.stackmap.MapMaker;
import org.drools.core.phreak.ReactiveCollection;
import org.drools.core.phreak.ReactiveList;
import org.drools.core.phreak.ReactiveObject;
import org.drools.core.phreak.ReactiveObjectUtil;
import org.drools.core.phreak.ReactiveSet;
import org.drools.core.spi.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BytecodeInjectReactive {
    public static final String DROOLS_PREFIX = "$$_drools_";
    public static final String FIELD_WRITER_PREFIX = "$$_drools_write_";
    public static final String DROOLS_LIST_OF_TUPLES = "$$_drools_lts";
    public static final Logger LOG = LoggerFactory.getLogger(BytecodeInjectReactive.class);
    private Map<String, CtMethod> writeMethods;
    private ClassPool cp;

    public BytecodeInjectReactive(ClassPool cp) {
        this.cp = cp;
        this.init();
    }

    public static BytecodeInjectReactive newInstance(ClassPool cp) {
        return new BytecodeInjectReactive(cp);
    }

    public static String classpathFromClass(Class<?> clazz) {
        String aname = clazz.getPackage().getName().replaceAll("\\.", "/") + "/" + clazz.getSimpleName() + ".class";
        String apath = ClassLoader.getSystemClassLoader().getResource(aname).getPath();
        String path = null;
        path = apath.contains("!") ? apath.substring(0, apath.indexOf("!")).replace("file:", "") : apath.substring(0, apath.indexOf(aname));
        return path;
    }

    private void init() {
        this.writeMethods = new HashMap<String, CtMethod>();
    }

    public byte[] injectReactive(String classname) throws Exception {
        this.init();
        CtClass droolsPojo = this.cp.get(classname);
        if (this.collectReactiveFields(droolsPojo).size() == 0) {
            LOG.info("Skipped bytecode injection in class " + droolsPojo.getName() + " because no fields candidated for reactivity.");
            return droolsPojo.toBytecode();
        }
        droolsPojo.addInterface(this.cp.get(ReactiveObject.class.getName()));
        CtField ltsCtField = new CtField(this.cp.get(Collection.class.getName()), DROOLS_LIST_OF_TUPLES, droolsPojo);
        ltsCtField.setModifiers(2);
        SignatureAttribute.ClassType listOfTuple = new SignatureAttribute.ClassType(Collection.class.getName(), new SignatureAttribute.TypeArgument[]{new SignatureAttribute.TypeArgument((SignatureAttribute.ObjectType)new SignatureAttribute.ClassType(Tuple.class.getName()))});
        ltsCtField.setGenericSignature(listOfTuple.encode());
        droolsPojo.addField(ltsCtField, CtField.Initializer.byExpr((String)"new java.util.HashSet();"));
        CtMethod getLeftTuplesCtMethod = CtNewMethod.make((String)"public java.util.Collection getLeftTuples() {\n    return this.$$_drools_lts != null ? this.$$_drools_lts : java.util.Collections.emptyList();\n}", (CtClass)droolsPojo);
        SignatureAttribute.MethodSignature getLeftTuplesSignature = new SignatureAttribute.MethodSignature(null, null, (SignatureAttribute.Type)listOfTuple, null);
        getLeftTuplesCtMethod.setGenericSignature(getLeftTuplesSignature.encode());
        droolsPojo.addMethod(getLeftTuplesCtMethod);
        CtMethod addLeftTupleCtMethod = CtNewMethod.make((String)("public void addLeftTuple(" + Tuple.class.getName() + " leftTuple) {\n    if ($$_drools_lts == null) {\n        $$_drools_lts = new java.util.HashSet();\n    }\n    $$_drools_lts.add(leftTuple);\n}"), (CtClass)droolsPojo);
        droolsPojo.addMethod(addLeftTupleCtMethod);
        CtMethod removeLeftTupleCtMethod = CtNewMethod.make((String)("public void removeLeftTuple(" + Tuple.class.getName() + " leftTuple) {\n    $$_drools_lts.remove(leftTuple);\n}"), (CtClass)droolsPojo);
        droolsPojo.addMethod(removeLeftTupleCtMethod);
        Map<String, CtField> fieldsMap = this.collectReactiveFields(droolsPojo);
        for (CtField f : fieldsMap.values()) {
            LOG.debug("Preparing field writer method for field: {}.", (Object)f);
            this.writeMethods.put(f.getName(), this.makeWriter(droolsPojo, f));
        }
        this.enhanceAttributesAccess(fieldsMap, droolsPojo);
        return droolsPojo.toBytecode();
    }

    protected void enhanceAttributesAccess(Map<String, CtField> fieldsMap, CtClass managedCtClass) throws Exception {
        ConstPool constPool = managedCtClass.getClassFile().getConstPool();
        ClassPool classPool = managedCtClass.getClassPool();
        for (Object oMethod : managedCtClass.getClassFile().getMethods()) {
            MethodInfo methodInfo = (MethodInfo)oMethod;
            String methodName = methodInfo.getName();
            if (methodName.startsWith(DROOLS_PREFIX) || methodInfo.getCodeAttribute() == null) continue;
            try {
                CodeIterator itr = methodInfo.getCodeAttribute().iterator();
                while (itr.hasNext()) {
                    String fieldName;
                    CtField ctField;
                    int index = itr.next();
                    int op = itr.byteAt(index);
                    if (op != 181 && op != 180 || (ctField = fieldsMap.get(fieldName = constPool.getFieldrefName(itr.u16bitAt(index + 1)))) == null || methodInfo.isConstructor() && !this.isCtFieldACollection(ctField) || op != 181) continue;
                    int methodIndex = BytecodeInjectReactive.addMethod(constPool, this.writeMethods.get(fieldName));
                    itr.writeByte(182, index);
                    itr.write16bit(methodIndex, index + 1);
                }
                methodInfo.getCodeAttribute().setAttribute(MapMaker.make((ClassPool)classPool, (MethodInfo)methodInfo));
            }
            catch (BadBytecode bb) {
                String msg = String.format("Unable to perform field access transformation in method [%s]", methodName);
                throw new Exception(msg, bb);
            }
        }
    }

    private static CtMethod write(CtClass target, String format, Object ... args) throws CannotCompileException {
        String body = String.format(format, args);
        LOG.debug("writing method into [{}]:\n{}\n", (Object)target.getName(), (Object)body);
        CtMethod method = CtNewMethod.make((String)body, (CtClass)target);
        target.addMethod(method);
        return method;
    }

    private static int addMethod(ConstPool cPool, CtMethod method) {
        return cPool.addMethodrefInfo(cPool.getThisClassInfo(), method.getName(), method.getSignature());
    }

    private CtMethod makeWriter(CtClass managedCtClass, CtField field) throws Exception {
        String fieldName = field.getName();
        String writerName = FIELD_WRITER_PREFIX + fieldName;
        return BytecodeInjectReactive.write(managedCtClass, "public void %s(%s %s) {%n%s%n}", writerName, field.getType().getName(), fieldName, this.buildWriteInterceptionBodyFragment(field));
    }

    private String buildWriteInterceptionBodyFragment(CtField field) throws NotFoundException {
        LOG.debug("buildWriteInterceptionBodyFragment: {} {}", field.getType().getClass(), (Object)field.getType());
        if (this.isCtFieldACollection(field)) {
            if (field.getType().equals(this.cp.get(Set.class.getName()))) {
                return String.format("  this.%1$s = new " + ReactiveSet.class.getName() + "($1); ", field.getName());
            }
            if (field.getType().equals(this.cp.get(List.class.getName()))) {
                return String.format("  this.%1$s = new " + ReactiveList.class.getName() + "($1); ", field.getName());
            }
            return String.format("  this.%1$s = new " + ReactiveCollection.class.getName() + "($1); ", field.getName());
        }
        return String.format("  this.%1$s = $1;%n  " + ReactiveObjectUtil.class.getName() + ".notifyModification($0); ", field.getName());
    }

    private Map<String, CtField> collectReactiveFields(CtClass managedCtClass) {
        HashMap<String, CtField> persistentFieldMap = new HashMap<String, CtField>();
        for (CtField ctField : managedCtClass.getDeclaredFields()) {
            if (Modifier.isStatic((int)ctField.getModifiers()) || ctField.getName().startsWith(DROOLS_PREFIX) || "this$0".equals(ctField.getName()) || Modifier.isFinal((int)ctField.getModifiers()) && !this.isCtFieldACollection(ctField)) continue;
            persistentFieldMap.put(ctField.getName(), ctField);
        }
        for (CtField ctField : managedCtClass.getFields()) {
            if (ctField.getDeclaringClass().equals(managedCtClass) || Modifier.isStatic((int)ctField.getModifiers()) || ctField.getName().startsWith(DROOLS_PREFIX)) continue;
            persistentFieldMap.put(ctField.getName(), ctField);
        }
        return persistentFieldMap;
    }

    private boolean isCtFieldACollection(CtField ctField) {
        try {
            return ctField.getType().equals(this.cp.get(Collection.class.getName())) || ctField.getType().equals(this.cp.get(List.class.getName())) || ctField.getType().equals(this.cp.get(Set.class.getName()));
        }
        catch (NotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }
}

