/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.maven.plugin;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.kie.kogito.maven.plugin.AbstractKieMojo;

@Mojo(name="touch", requiresProject=true, defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class TouchResourcesMojo
extends AbstractKieMojo {
    @Parameter(property="kie.ruleFiles", required=true)
    private List<String> ruleFiles;
    @Parameter(property="kie.kiebases", required=true)
    private List<String> kiebases;
    @Parameter(property="kie.resDirectory", defaultValue="${project.basedir}/res/raw")
    private String resDirectory;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            File outputFolder = new File(this.resDirectory);
            outputFolder.mkdirs();
            for (String kbase : this.kiebases) {
                this.getLog().info((CharSequence)("Touching KBase: " + kbase));
                File file = new File(outputFolder, kbase.replace('.', '_').toLowerCase());
                file.createNewFile();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("error", e);
        }
    }
}

