/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.CumulativeScopeArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kie.builder.impl.ZipKieModule;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.kogito.codegen.ApplicationGenerator;
import org.kie.kogito.codegen.GeneratedFile;
import org.kie.kogito.codegen.Generator;
import org.kie.kogito.codegen.process.ProcessCodegen;
import org.kie.kogito.codegen.rules.RuleCodegen;
import org.kie.kogito.maven.plugin.AbstractKieMojo;

@Mojo(name="generateModel", requiresDependencyResolution=ResolutionScope.NONE, requiresProject=true, defaultPhase=LifecyclePhase.COMPILE)
public class GenerateModelMojo
extends AbstractKieMojo {
    public static PathMatcher drlFileMatcher = FileSystems.getDefault().getPathMatcher("glob:**.drl");
    @Parameter(required=true, defaultValue="${project.build.directory}")
    private File targetDirectory;
    @Parameter(required=true, defaultValue="${project.basedir}")
    private File projectDir;
    @Parameter(required=true, defaultValue="${project.build.testSourceDirectory}")
    private File testDir;
    @Parameter
    private Map<String, String> properties;
    @Parameter(required=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(required=true, defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/kogito")
    private File generatedSources;
    @Parameter(property="kogito.codegen.rules", defaultValue="")
    private String generateRules;
    @Parameter(property="kogito.codegen.processes", defaultValue="")
    private String generateProcesses;
    @Parameter(property="kogito.sources.keep", defaultValue="false")
    private boolean keepSources;
    @Parameter(property="kogito.di.enabled", defaultValue="true")
    private boolean dependencyInjection;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.generateModel();
        }
        catch (IOException e) {
            throw new MojoExecutionException("An I/O error occurred", (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateModel() throws MojoExecutionException, IOException {
        boolean genRules = this.generateRules == null ? this.rulesExist() : Boolean.parseBoolean(this.generateRules);
        boolean genProcesses = this.generateProcesses == null ? this.processesExist() : Boolean.parseBoolean(this.generateProcesses);
        this.project.addCompileSourceRoot(this.generatedSources.getPath());
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            this.setSystemProperties(this.properties);
            ClassLoader projectClassLoader = this.createProjectClassLoader();
            Thread.currentThread().setContextClassLoader(projectClassLoader);
            ApplicationGenerator appGen = this.createApplicationGenerator(genRules, genProcesses);
            for (GeneratedFile generatedFile : appGen.generate()) {
                this.writeGeneratedFile(generatedFile);
            }
            if (!this.keepSources) {
                this.deleteDrlFiles();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private boolean processesExist() throws IOException {
        return Files.walk(this.projectDir.toPath(), new FileVisitOption[0]).map(p -> p.toString().toLowerCase()).anyMatch(p -> p.endsWith(".bpmn") || p.endsWith(".bpmn2"));
    }

    private boolean rulesExist() throws IOException {
        return Files.walk(this.projectDir.toPath(), new FileVisitOption[0]).anyMatch(p -> p.toString().toLowerCase().endsWith(".drl"));
    }

    private ApplicationGenerator createApplicationGenerator(boolean generateRuleUnits, boolean generateProcesses) throws IOException {
        String appPackageName = this.project.getGroupId();
        Path projectPath = this.projectDir.toPath();
        if (appPackageName.equals("org.kie.kogito")) {
            appPackageName = "org.kie.kogito.app";
        }
        ApplicationGenerator appGen = new ApplicationGenerator(appPackageName, this.targetDirectory).withDependencyInjection(this.dependencyInjection);
        if (generateRuleUnits) {
            ((RuleCodegen)appGen.withGenerator((Generator)RuleCodegen.ofPath((Path)projectPath, (boolean)false))).withRuleEventListenersConfig(this.customRuleEventListenerConfigExists(appPackageName));
        }
        if (generateProcesses) {
            ((ProcessCodegen)appGen.withGenerator((Generator)ProcessCodegen.ofPath((Path)projectPath))).withWorkItemHandlerConfig(this.customWorkItemConfigExists(appPackageName)).withProcessEventListenerConfig(this.customProcessListenerConfigExists(appPackageName));
        }
        return appGen;
    }

    private String customWorkItemConfigExists(String appPackageName) {
        String sourceDir = Paths.get(this.projectDir.getPath(), "src").toString();
        String workItemHandlerConfigClass = ProcessCodegen.defaultWorkItemHandlerConfigClass((String)appPackageName);
        Path p = Paths.get(sourceDir, "main/java", workItemHandlerConfigClass.replace('.', '/') + ".java");
        return Files.exists(p, new LinkOption[0]) ? workItemHandlerConfigClass : null;
    }

    private String customProcessListenerConfigExists(String appPackageName) {
        String sourceDir = Paths.get(this.projectDir.getPath(), "src").toString();
        String processEventListenerClass = ProcessCodegen.defaultProcessListenerConfigClass((String)appPackageName);
        Path p = Paths.get(sourceDir, "main/java", processEventListenerClass.replace('.', '/') + ".java");
        return Files.exists(p, new LinkOption[0]) ? processEventListenerClass : null;
    }

    private String customRuleEventListenerConfigExists(String appPackageName) {
        String sourceDir = Paths.get(this.projectDir.getPath(), "src").toString();
        String ruleEventListenerConfiglass = RuleCodegen.defaultRuleEventListenerConfigClass((String)appPackageName);
        Path p = Paths.get(sourceDir, "main/java", ruleEventListenerConfiglass.replace('.', '/') + ".java");
        return Files.exists(p, new LinkOption[0]) ? ruleEventListenerConfiglass : null;
    }

    private void writeAll(List<GeneratedFile> generatedFiles) throws IOException {
        for (GeneratedFile f : generatedFiles) {
            this.writeGeneratedFile(f);
        }
    }

    private void writeGeneratedFile(GeneratedFile f) throws IOException {
        Files.write(this.pathOf(f.relativePath()), f.contents(), new OpenOption[0]);
    }

    private Path pathOf(String end) {
        Path path = Paths.get(this.generatedSources.getPath(), end);
        path.getParent().toFile().mkdirs();
        return path;
    }

    private ClassLoader createProjectClassLoader() throws MojoExecutionException {
        try {
            ArrayList<ZipKieModule> kmoduleDeps = new ArrayList<ZipKieModule>();
            HashSet<URL> urls = new HashSet<URL>();
            for (String element : this.project.getCompileClasspathElements()) {
                urls.add(new File(element).toURI().toURL());
            }
            this.project.setArtifactFilter((ArtifactFilter)new CumulativeScopeArtifactFilter(Arrays.asList("compile", "runtime")));
            for (Artifact artifact : this.project.getArtifacts()) {
                File file = artifact.getFile();
                if (file == null) continue;
                urls.add(file.toURI().toURL());
                KieModuleModel depModel = this.getDependencyKieModel(file);
                if (depModel == null) continue;
                ReleaseIdImpl releaseId = new ReleaseIdImpl(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
                kmoduleDeps.add(new ZipKieModule((ReleaseId)releaseId, depModel, file));
            }
            urls.add(this.outputDirectory.toURI().toURL());
            return URLClassLoader.newInstance(urls.toArray(new URL[0]), ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (MalformedURLException | DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Error setting up Kie ClassLoader", (Exception)e);
        }
    }

    private void deleteDrlFiles() throws MojoExecutionException {
        try {
            Stream<Path> drlFiles = Files.find(this.outputDirectory.toPath(), Integer.MAX_VALUE, (p, f) -> drlFileMatcher.matches((Path)p), new FileVisitOption[0]);
            drlFiles.forEach(p -> {
                try {
                    Files.delete(p);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException("Unable to delete file " + p);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MojoExecutionException("Unable to find .drl files");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KieModuleModel getDependencyKieModel(File jar) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(jar);
            ZipEntry zipEntry = zipFile.getEntry("META-INF/kmodule.xml");
            if (zipEntry != null) {
                KieModuleModel kieModuleModel = KieModuleModelImpl.fromXML((InputStream)zipFile.getInputStream(zipEntry));
                KieBuilderImpl.setDefaultsforEmptyKieModule((KieModuleModel)kieModuleModel);
                KieModuleModel kieModuleModel2 = kieModuleModel;
                return kieModuleModel2;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }
}

