/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.drools.compiler.commons.jci.stores.ResourceStore;
import org.drools.compiler.compiler.io.memory.MemoryFile;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kie.builder.impl.KieMetaInfoBuilder;
import org.drools.compiler.kie.builder.impl.MemoryKieModule;
import org.drools.compiler.kie.builder.impl.ResultsImpl;
import org.kie.api.KieServices;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.internal.io.ResourceFactory;
import org.kie.kogito.maven.plugin.AbstractKieMojo;
import org.kie.kogito.maven.plugin.CompilerHelper;
import org.kie.kogito.maven.plugin.DiskResourceStore;
import org.kie.kogito.maven.plugin.ExecModelMode;
import org.kie.kogito.maven.plugin.util.MojoUtil;

@Mojo(name="build", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresProject=true, defaultPhase=LifecyclePhase.COMPILE)
public class BuildMojo
extends AbstractKieMojo {
    @Parameter(required=true, defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(required=true, defaultValue="${project.build.directory}")
    private File targetDirectory;
    @Parameter(required=true, defaultValue="src/main/resources")
    private File sourceFolder;
    @Parameter(required=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter
    private Map<String, String> properties;
    @Parameter(required=false, defaultValue="no")
    private String usesPMML;
    @Inject
    private PlexusContainer container;
    @Parameter(property="generateModel", defaultValue="no")
    private String generateModel;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!ExecModelMode.shouldGenerateModel(this.generateModel)) {
            this.buildDrl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildDrl() throws MojoFailureException, MojoExecutionException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            List errors;
            ArrayList<InternalKieModule> kmoduleDeps = new ArrayList<InternalKieModule>();
            ClassLoader projectClassLoader = MojoUtil.createProjectClassLoader(((Object)((Object)this)).getClass().getClassLoader(), this.project, this.outputDirectory, kmoduleDeps);
            Thread.currentThread().setContextClassLoader(projectClassLoader);
            KieServices ks = KieServices.Factory.get();
            this.setSystemProperties(this.properties);
            KieFileSystem kfs = ks.newKieFileSystem();
            for (File file : this.getResourceFiles(this.sourceFolder)) {
                if (file.getPath().contains("META-INF")) continue;
                kfs.write(ResourceFactory.newFileResource((File)file));
            }
            KieBuilderImpl kieBuilder = new KieBuilderImpl(kfs);
            InternalKieModule kModule = (InternalKieModule)kieBuilder.getKieModule();
            for (InternalKieModule kmoduleDep : kmoduleDeps) {
                kModule.addKieDependency(kmoduleDep);
            }
            kieBuilder.buildAll();
            ResultsImpl messages = (ResultsImpl)kieBuilder.getResults();
            List list = errors = messages != null ? messages.filterMessages(new Message.Level[]{Message.Level.ERROR}) : Collections.emptyList();
            if (this.container != null) {
                Map<String, Object> kieMap = this.getKieMap();
                if (!kieMap.isEmpty()) {
                    CompilerHelper helper = new CompilerHelper();
                    helper.share(kieMap, kModule, this.getLog());
                } else {
                    this.getLog().info((CharSequence)"Kie Map empty");
                }
            } else {
                new KieMetaInfoBuilder(kModule).writeKieModuleMetaInfo((ResourceStore)new DiskResourceStore(this.outputDirectory));
            }
            if (!errors.isEmpty()) {
                for (Message error : errors) {
                    this.getLog().error((CharSequence)error.toString());
                }
                throw new MojoFailureException("Build failed!");
            }
            this.writeClassFiles(kModule);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        this.getLog().info((CharSequence)"KieModule successfully built!");
    }

    private List<File> getResourceFiles(File parent) {
        File[] children;
        ArrayList<File> files = new ArrayList<File>();
        if (parent.isDirectory() && (children = parent.listFiles()) != null) {
            for (File child : children) {
                if (child.isDirectory()) {
                    files.addAll(this.getResourceFiles(child));
                    continue;
                }
                files.add(child);
            }
        }
        return files;
    }

    private void writeClassFiles(InternalKieModule kModule) throws MojoFailureException {
        MemoryFileSystem mfs = ((MemoryKieModule)kModule).getMemoryFileSystem();
        for (String name : kModule.getFileNames()) {
            if (!name.endsWith(".class")) continue;
            this.saveFile(mfs, name);
        }
    }

    private void saveFile(MemoryFileSystem mfs, String fileName) throws MojoFailureException {
        MemoryFile memFile = (MemoryFile)mfs.getFile(fileName);
        Path path = Paths.get(this.outputDirectory.getPath(), memFile.getPath().toPortableString());
        try {
            Files.deleteIfExists(path);
            Files.createDirectories(path, new FileAttribute[0]);
            Files.copy(memFile.getContents(), path, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException iox) {
            throw new MojoFailureException("Unable to write file", (Throwable)iox);
        }
    }

    private Map<String, Object> getKieMap() {
        try {
            Map kieMap = (Map)this.container.lookup(Map.class, "java.util.HashMap", "kieMap");
            return Optional.ofNullable(kieMap).orElse(Collections.emptyMap());
        }
        catch (ComponentLookupException cle) {
            this.getLog().info((CharSequence)"kieMap not present");
            return Collections.emptyMap();
        }
    }
}

