/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.maven.plugin;

import java.util.HashSet;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;
import org.drools.compiler.kie.builder.impl.FileKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieMetaInfoBuilder;
import org.drools.core.rule.KieModuleMetaInfo;
import org.drools.core.rule.TypeMetaInfo;
import org.drools.reflective.classloader.ProjectClassLoader;

class CompilerHelper {
    CompilerHelper() {
    }

    public void share(Map<String, Object> kieMap, InternalKieModule kModule, Log log) {
        String compilationID = this.getCompilationID(kieMap, log);
        this.shareKieObjectsWithMap(kModule, compilationID, kieMap, log);
        this.shareStoreWithMap(kModule.getModuleClassLoader(), compilationID, kieMap, log);
        this.shareTypesMetaInfoWithMap(this.getTypeMetaInfo(kModule), kieMap, compilationID, log);
    }

    public String getCompilationID(Map<String, Object> kieMap, Log log) {
        Object compilationIDObj = kieMap.get("compilation.ID");
        if (compilationIDObj != null) {
            return compilationIDObj.toString();
        }
        log.error((CharSequence)("compilation.ID key not present in the shared map using thread name:" + Thread.currentThread().getName()));
        return Thread.currentThread().getName();
    }

    public void shareKieObjectsWithMap(InternalKieModule kModule, String compilationID, Map<String, Object> kieMap, Log log) {
        if (kModule != null && compilationID != null) {
            KieMetaInfoBuilder builder = new KieMetaInfoBuilder(kModule);
            KieModuleMetaInfo modelMetaInfo = builder.getKieModuleMetaInfo();
            if (modelMetaInfo != null) {
                StringBuilder sbModelMetaInfo = new StringBuilder(compilationID).append(".").append(KieModuleMetaInfo.class.getName());
                kieMap.put(sbModelMetaInfo.toString(), modelMetaInfo);
                log.info((CharSequence)("KieModelMetaInfo available in the map shared with the Maven Embedder with key:" + sbModelMetaInfo.toString()));
            }
            StringBuilder sbkModule = new StringBuilder(compilationID).append(".").append(FileKieModule.class.getName());
            kieMap.put(sbkModule.toString(), kModule);
            log.info((CharSequence)("KieModule available in the map shared with the Maven Embedder with key:" + sbkModule.toString()));
        }
    }

    public void shareStoreWithMap(ClassLoader classLoader, String compilationID, Map<String, Object> kieMap, Log log) {
        if (classLoader instanceof ProjectClassLoader) {
            ProjectClassLoader projectClassloder = (ProjectClassLoader)classLoader;
            Map types = projectClassloder.getStore();
            if (projectClassloder.getStore() != null) {
                StringBuilder sbTypes = new StringBuilder(compilationID).append(".").append("ProjectClassloaderStore");
                kieMap.put(sbTypes.toString(), types);
                log.info((CharSequence)"ProjectClassloader Store available in the map shared with the Maven Embedder");
            }
        }
    }

    public void shareTypesMetaInfoWithMap(Map<String, TypeMetaInfo> typesMetaInfo, Map<String, Object> kieMap, String compilationID, Log log) {
        if (typesMetaInfo != null) {
            StringBuilder sbTypes = new StringBuilder(compilationID).append(".").append(TypeMetaInfo.class.getName());
            HashSet<String> eventClasses = new HashSet<String>();
            for (Map.Entry<String, TypeMetaInfo> item : typesMetaInfo.entrySet()) {
                if (!item.getValue().isEvent()) continue;
                eventClasses.add(item.getKey());
            }
            if (!eventClasses.isEmpty()) {
                kieMap.put(sbTypes.toString(), eventClasses);
                log.info((CharSequence)"TypesMetaInfo keys available in the map shared with the Maven Embedder");
            }
        }
    }

    public Map<String, TypeMetaInfo> getTypeMetaInfo(InternalKieModule kModule) {
        KieMetaInfoBuilder kb = new KieMetaInfoBuilder(kModule);
        KieModuleMetaInfo info = kb.generateKieModuleMetaInfo(null);
        return info.getTypeMetaInfos();
    }
}

