/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.maven.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import org.drools.compiler.commons.jci.stores.ResourceStore;
import org.drools.core.util.IoUtils;

public class DiskResourceStore
implements ResourceStore {
    private final File root;

    public DiskResourceStore(File root) {
        this.root = root;
    }

    public void write(String pResourceName, byte[] pResourceData) {
        this.write(pResourceName, pResourceData, false);
    }

    public void write(String pResourceName, byte[] pResourceData, boolean createFolder) {
        File dir;
        File file = new File(this.getFilePath(pResourceName));
        if (createFolder && !(dir = file.getParentFile()).exists()) {
            dir.mkdirs();
        }
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(pResourceData);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] read(String pResourceName) {
        try (FileInputStream fis = new FileInputStream(this.getFilePath(pResourceName));){
            byte[] byArray = IoUtils.readBytesFromInputStream((InputStream)fis);
            return byArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void remove(String pResourceName) {
        File file = new File(this.getFilePath(pResourceName));
        try {
            Files.deleteIfExists(file.toPath());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String getFilePath(String pResourceName) {
        return this.root.getAbsolutePath() + File.separator + pResourceName;
    }
}

