/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.maven.plugin;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.drools.compiler.builder.impl.KogitoKieModuleModelImpl;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.kogito.codegen.AddonsConfig;
import org.kie.kogito.codegen.ApplicationGenerator;
import org.kie.kogito.codegen.DashboardGeneratedFileUtils;
import org.kie.kogito.codegen.GeneratedFile;
import org.kie.kogito.codegen.Generator;
import org.kie.kogito.codegen.GeneratorContext;
import org.kie.kogito.codegen.decision.DecisionCodegen;
import org.kie.kogito.codegen.io.CollectedResource;
import org.kie.kogito.codegen.prediction.PredictionCodegen;
import org.kie.kogito.codegen.process.ProcessCodegen;
import org.kie.kogito.codegen.rules.IncrementalRuleCodegen;
import org.kie.kogito.maven.plugin.AbstractKieMojo;
import org.kie.kogito.maven.plugin.util.MojoUtil;

@Mojo(name="generateModel", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresProject=true, defaultPhase=LifecyclePhase.COMPILE, threadSafe=true)
public class GenerateModelMojo
extends AbstractKieMojo {
    public static final List<String> DROOLS_EXTENSIONS = Arrays.asList(".drl", ".xls", ".xlsx", ".csv");
    public static final PathMatcher drlFileMatcher = FileSystems.getDefault().getPathMatcher("glob:**.drl");
    @Parameter(required=true, defaultValue="${project.build.directory}")
    private File targetDirectory;
    @Parameter(required=true, defaultValue="${project.basedir}")
    private File projectDir;
    @Parameter(required=true, defaultValue="${project.build.testSourceDirectory}")
    private File testDir;
    @Parameter
    private Map<String, String> properties;
    @Parameter(required=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(required=true, defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(property="kogito.codegen.sources.directory", defaultValue="${project.build.directory}/generated-sources/kogito")
    private File customizableSources;
    @Parameter(readonly=true, defaultValue="${project.build.directory}/generated-sources/kogito")
    private File generatedSources;
    @Parameter(property="kogito.codegen.rules", defaultValue="")
    private String generateRules;
    @Parameter(property="kogito.codegen.processes", defaultValue="")
    private String generateProcesses;
    @Parameter(property="kogito.codegen.decisions", defaultValue="")
    private String generateDecisions;
    @Parameter(property="kogito.codegen.predictions", defaultValue="")
    private String generatePredictions;
    @Parameter(property="kogito.codegen.partial", defaultValue="false")
    private boolean generatePartial;
    @Parameter(property="kogito.codegen.ondemand", defaultValue="false")
    private boolean onDemand;
    @Parameter(property="kogito.sources.keep", defaultValue="false")
    private boolean keepSources;
    @Parameter(property="kogito.persistence.enabled", defaultValue="false")
    private boolean persistence;
    @Parameter(required=true, defaultValue="${project.basedir}/src/main/resources")
    private File kieSourcesDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.addCompileSourceRoots();
            if (this.isOnDemand()) {
                this.getLog().info((CharSequence)"On-Demand Mode is On. Use mvn compile kogito:scaffold");
            } else {
                this.generateModel();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("An I/O error occurred", (Exception)e);
        }
    }

    protected boolean isOnDemand() {
        return this.onDemand;
    }

    protected File getCustomizableSources() {
        return this.customizableSources;
    }

    protected void addCompileSourceRoots() {
        this.project.addCompileSourceRoot(this.getCustomizableSources().getPath());
        this.project.addCompileSourceRoot(this.generatedSources.getPath());
    }

    protected void generateModel() throws MojoExecutionException, IOException {
        this.setSystemProperties(this.properties);
        ApplicationGenerator appGen = this.createApplicationGenerator();
        Collection generatedFiles = this.generatePartial ? appGen.generateComponents() : appGen.generate();
        Optional dashboardsListFile = DashboardGeneratedFileUtils.list((Collection)generatedFiles);
        dashboardsListFile.ifPresent(generatedFiles::add);
        for (GeneratedFile generatedFile : generatedFiles) {
            this.writeGeneratedFile(generatedFile);
        }
        if (!this.keepSources) {
            this.deleteDrlFiles();
        }
    }

    private boolean generateDecisions() throws IOException {
        return this.generateDecisions == null ? this.decisionsExist() : Boolean.parseBoolean(this.generateDecisions);
    }

    private boolean generatePredictions() throws IOException {
        return this.generatePredictions == null ? this.predictionsExist() : Boolean.parseBoolean(this.generatePredictions);
    }

    private boolean generateRules() throws IOException {
        return this.generateRules == null ? this.rulesExist() : Boolean.parseBoolean(this.generateRules);
    }

    private boolean generateProcesses() throws IOException {
        return this.generateProcesses == null ? this.processesExist() : Boolean.parseBoolean(this.generateProcesses);
    }

    private boolean decisionsExist() throws IOException {
        try (Stream<Path> paths = Files.walk(this.projectDir.toPath(), new FileVisitOption[0]);){
            boolean bl = paths.map(p -> p.toString().toLowerCase()).anyMatch(p -> p.endsWith(".dmn"));
            return bl;
        }
    }

    private boolean predictionsExist() throws IOException {
        try (Stream<Path> paths = Files.walk(this.projectDir.toPath(), new FileVisitOption[0]);){
            boolean bl = paths.map(p -> p.toString().toLowerCase()).anyMatch(p -> p.endsWith(".pmml"));
            return bl;
        }
    }

    private boolean processesExist() throws IOException {
        try (Stream<Path> paths = Files.walk(this.projectDir.toPath(), new FileVisitOption[0]);){
            boolean bl = paths.map(p -> p.toString().toLowerCase()).anyMatch(p -> p.endsWith(".bpmn") || p.endsWith(".bpmn2") || p.endsWith(".sw.json") || p.endsWith(".sw.yml"));
            return bl;
        }
    }

    private boolean rulesExist() throws IOException {
        try (Stream<Path> paths = Files.walk(this.projectDir.toPath(), new FileVisitOption[0]);){
            boolean bl = paths.map(p -> p.toString().toLowerCase()).map(p -> {
                int dot = p.lastIndexOf(46);
                return dot > 0 ? p.substring(dot) : "";
            }).anyMatch(DROOLS_EXTENSIONS::contains);
            return bl;
        }
    }

    private ApplicationGenerator createApplicationGenerator() throws IOException, MojoExecutionException {
        String appPackageName = this.project.getGroupId();
        if (appPackageName.equals("org.kie.kogito")) {
            appPackageName = "org.kie.kogito.app";
        }
        boolean usePersistence = this.persistence || this.hasClassOnClasspath(this.project, "org.kie.kogito.persistence.KogitoProcessInstancesFactory");
        boolean useMonitoring = this.hasClassOnClasspath(this.project, "org.kie.kogito.monitoring.rest.MetricsResource");
        boolean useTracing = this.hasClassOnClasspath(this.project, "org.kie.kogito.tracing.decision.DecisionTracingListener");
        boolean useKnativeEventing = this.hasClassOnClasspath(this.project, "org.kie.kogito.events.knative.ce.extensions.KogitoProcessExtension");
        boolean useCloudEvents = this.hasClassOnClasspath(this.project, "org.kie.kogito.addon.cloudevents.AbstractTopicDiscovery");
        AddonsConfig addonsConfig = new AddonsConfig().withPersistence(usePersistence).withMonitoring(useMonitoring).withTracing(useTracing).withKnativeEventing(useKnativeEventing).withCloudEvents(useCloudEvents);
        ClassLoader projectClassLoader = MojoUtil.createProjectClassLoader(((Object)((Object)this)).getClass().getClassLoader(), this.project, this.outputDirectory, null);
        GeneratorContext context = GeneratorContext.ofResourcePath((File[])new File[]{this.kieSourcesDirectory});
        context.withBuildContext(this.discoverKogitoRuntimeContext(this.project));
        ApplicationGenerator appGen = new ApplicationGenerator(appPackageName, this.targetDirectory).withDependencyInjection(this.discoverDependencyInjectionAnnotator(this.project)).withAddons(addonsConfig).withClassLoader(projectClassLoader).withGeneratorContext(context);
        if (this.generateProcesses()) {
            ((ProcessCodegen)appGen.withGenerator((Generator)ProcessCodegen.ofCollectedResources((Collection)CollectedResource.fromDirectory((Path)this.kieSourcesDirectory.toPath())))).withAddons(addonsConfig).withClassLoader(projectClassLoader);
        }
        if (this.generateRules()) {
            boolean useRestServices = this.hasClassOnClasspath(this.project, "javax.ws.rs.Path");
            ((IncrementalRuleCodegen)appGen.withGenerator((Generator)IncrementalRuleCodegen.ofCollectedResources((Collection)CollectedResource.fromDirectory((Path)this.kieSourcesDirectory.toPath())))).withKModule(this.getKModuleModel()).withClassLoader(projectClassLoader).withAddons(addonsConfig).withRestServices(useRestServices);
        }
        boolean isJPMMLAvailable = this.hasClassOnClasspath(this.project, "org.kie.dmn.jpmml.DMNjPMMLInvocationEvaluator");
        ((PredictionCodegen)appGen.withGenerator((Generator)PredictionCodegen.ofCollectedResources((boolean)isJPMMLAvailable, (Collection)CollectedResource.fromDirectory((Path)this.kieSourcesDirectory.toPath())))).withAddons(addonsConfig);
        if (this.generateDecisions()) {
            ((DecisionCodegen)appGen.withGenerator((Generator)DecisionCodegen.ofCollectedResources((Collection)CollectedResource.fromDirectory((Path)this.kieSourcesDirectory.toPath())))).withAddons(addonsConfig).withClassLoader(projectClassLoader).withPCLResolverFn(x -> this.hasClassOnClasspath(this.project, (String)x));
        }
        return appGen;
    }

    private KieModuleModel getKModuleModel() throws IOException {
        if (!this.project.getResources().isEmpty()) {
            KieModuleModel kieModuleModel;
            Path moduleXmlPath = Paths.get(((Resource)this.project.getResources().get(0)).getDirectory(), new String[0]).resolve("META-INF/kmodule.xml");
            ByteArrayInputStream bais = new ByteArrayInputStream(Files.readAllBytes(moduleXmlPath));
            try {
                kieModuleModel = KogitoKieModuleModelImpl.fromXML((InputStream)bais);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        bais.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (NoSuchFileException e) {
                    this.getLog().debug((CharSequence)"kmodule.xml is missing. Returned the default value.", (Throwable)e);
                    return new KogitoKieModuleModelImpl();
                }
            }
            bais.close();
            return kieModuleModel;
        }
        this.getLog().debug((CharSequence)"kmodule.xml is missing. Returned the default value.");
        return new KogitoKieModuleModelImpl();
    }

    private void writeGeneratedFile(GeneratedFile f) throws IOException {
        Files.write(this.pathOf(f), f.contents(), new OpenOption[0]);
    }

    private Path pathOf(GeneratedFile f) {
        Path path;
        if (f.getType() == GeneratedFile.Type.GENERATED_CP_RESOURCE) {
            File sourceFolder = this.outputDirectory;
            path = Paths.get(sourceFolder.getPath(), f.relativePath());
            this.getLog().info((CharSequence)("Generating: " + path));
        } else if (f.getType().isCustomizable()) {
            File sourceFolder = this.getCustomizableSources();
            path = Paths.get(sourceFolder.getPath(), f.relativePath());
            this.getLog().info((CharSequence)("Generating: " + path));
        } else {
            File sourceFolder = this.generatedSources;
            path = Paths.get(sourceFolder.getPath(), f.relativePath());
        }
        path.getParent().toFile().mkdirs();
        return path;
    }

    private void deleteDrlFiles() throws MojoExecutionException {
        try (Stream<Path> drlFiles = Files.find(this.outputDirectory.toPath(), Integer.MAX_VALUE, (p, f) -> drlFileMatcher.matches((Path)p), new FileVisitOption[0]);){
            drlFiles.forEach(p -> {
                try {
                    Files.delete(p);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to find .drl files");
        }
    }
}

