/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.drools.compiler.commons.jci.compilers.CompilationResult;
import org.drools.compiler.commons.jci.compilers.JavaCompiler;
import org.drools.compiler.commons.jci.compilers.JavaCompilerFactory;
import org.drools.compiler.commons.jci.compilers.JavaCompilerSettings;
import org.drools.compiler.commons.jci.readers.ResourceReader;
import org.drools.compiler.commons.jci.stores.ResourceStore;
import org.drools.compiler.compiler.JavaConfiguration;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.jbpm.util.JsonSchemaUtil;
import org.kie.kogito.Model;
import org.kie.kogito.UserTask;
import org.kie.kogito.codegen.GeneratedFile;
import org.kie.kogito.codegen.GeneratorContext;
import org.kie.kogito.codegen.JsonSchemaGenerator;
import org.kie.kogito.codegen.process.persistence.PersistenceGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ProtoGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ReflectionProtoGenerator;
import org.kie.kogito.maven.plugin.AbstractKieMojo;
import org.kie.kogito.process.ProcessInstancesFactory;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ConfigurationBuilder;

@Mojo(name="process-model-classes", requiresDependencyResolution=ResolutionScope.RUNTIME, requiresProject=true, defaultPhase=LifecyclePhase.PROCESS_CLASSES, threadSafe=true)
public class ProcessClassesMojo
extends AbstractKieMojo {
    private static final JavaCompiler JAVA_COMPILER = JavaCompilerFactory.INSTANCE.loadCompiler(JavaConfiguration.CompilerType.NATIVE, "1.8");
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(required=true, defaultValue="${project.basedir}/src/main/resources")
    private File kieSourcesDirectory;
    @Parameter(property="kogito.jsonSchema.version", required=false)
    private String schemaVersion;

    public void execute() throws MojoExecutionException {
        try {
            JavaCompilerSettings settings = new JavaCompilerSettings();
            ArrayList<URL> pathUrls = new ArrayList<URL>();
            for (String path : this.project.getRuntimeClasspathElements()) {
                pathUrls.add(new File(path).toURI().toURL());
                settings.addClasspath(path);
            }
            URL[] urlsForClassLoader = pathUrls.toArray(new URL[pathUrls.size()]);
            try (URLClassLoader cl = new URLClassLoader(urlsForClassLoader, Thread.currentThread().getContextClassLoader());){
                ConfigurationBuilder builder = new ConfigurationBuilder();
                builder.addUrls(cl.getURLs());
                builder.addClassLoader((ClassLoader)cl);
                Reflections reflections = new Reflections((Configuration)builder);
                Set modelClasses = reflections.getSubTypesOf(Model.class);
                String appPackageName = this.project.getGroupId();
                if (appPackageName.equals("org.kie.kogito")) {
                    appPackageName = "org.kie.kogito.app";
                }
                ArrayList<String> parameters = new ArrayList<String>();
                Set classes = reflections.getSubTypesOf(ProcessInstancesFactory.class);
                if (!classes.isEmpty()) {
                    Class c = (Class)classes.iterator().next();
                    for (Type t : c.getConstructors()[0].getGenericParameterTypes()) {
                        parameters.add(t.getTypeName());
                    }
                }
                GeneratorContext context = GeneratorContext.ofResourcePath((File[])new File[]{this.kieSourcesDirectory});
                context.withBuildContext(this.discoverKogitoRuntimeContext(this.project));
                String persistenceType = context.getApplicationProperty("kogito.persistence.type").orElse("infinispan");
                PersistenceGenerator persistenceGenerator = new PersistenceGenerator(new File(this.project.getBuild().getDirectory()), (Collection)modelClasses, !classes.isEmpty(), (ProtoGenerator)new ReflectionProtoGenerator(), (ClassLoader)cl, parameters, persistenceType);
                persistenceGenerator.setPackageName(appPackageName);
                persistenceGenerator.setDependencyInjection(this.discoverDependencyInjectionAnnotator(this.project));
                persistenceGenerator.setContext(context);
                Collection generatedFiles = persistenceGenerator.generate();
                generatedFiles = generatedFiles.stream().filter(x -> x.getType().equals((Object)GeneratedFile.Type.CLASS)).collect(Collectors.toList());
                MemoryFileSystem srcMfs = new MemoryFileSystem();
                MemoryFileSystem trgMfs = new MemoryFileSystem();
                String[] sources = new String[generatedFiles.size()];
                int index = 0;
                for (GeneratedFile entry : generatedFiles) {
                    String fileName = entry.relativePath();
                    sources[index++] = fileName;
                    srcMfs.write(fileName, entry.contents());
                }
                Path path = Paths.get(this.project.getBuild().getOutputDirectory(), new String[0]);
                if (sources.length > 0) {
                    CompilationResult result = JAVA_COMPILER.compile(sources, (ResourceReader)srcMfs, (ResourceStore)trgMfs, (ClassLoader)cl, settings);
                    if (result.getErrors().length > 0) {
                        throw new MojoFailureException(Arrays.toString(result.getErrors()));
                    }
                    for (String fileName : trgMfs.getFileNames()) {
                        byte[] data = trgMfs.getBytes(fileName);
                        this.writeFile(path, fileName, data);
                    }
                }
                this.generateJsonSchema(path, reflections);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error during processing model classes", e);
        }
    }

    private void generateJsonSchema(Path path, Reflections reflections) throws MojoFailureException {
        try {
            Collection files = new JsonSchemaGenerator.ClassBuilder(reflections.getTypesAnnotatedWith(UserTask.class).stream()).withGenSchemaPredicate(x -> true).withSchemaVersion(this.schemaVersion).build().generate();
            if (!files.isEmpty()) {
                Path parentPath = path.resolve(JsonSchemaUtil.getJsonDir());
                Files.createDirectories(parentPath, new FileAttribute[0]);
                for (GeneratedFile file : files) {
                    if (this.getLog().isInfoEnabled()) {
                        this.getLog().info((CharSequence)("Creating JSON schema file " + file.relativePath()));
                    }
                    Files.write(parentPath.resolve(file.relativePath()), file.contents(), new OpenOption[0]);
                }
            }
        }
        catch (Exception ex) {
            throw new MojoFailureException("Error generating json schema for tasks", (Throwable)ex);
        }
    }

    private Path writeFile(Path parentPath, String fileName, byte[] data) throws IOException {
        Path path = parentPath.resolve(fileName);
        if (!path.getParent().toFile().exists()) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        Files.write(path, data, new OpenOption[0]);
        return path;
    }
}

