/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Collection;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.core.ApplicationGenerator;
import org.kie.kogito.codegen.core.utils.ApplicationGeneratorDiscovery;
import org.kie.kogito.maven.plugin.AbstractKieMojo;

@Mojo(name="generateModel", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresProject=true, defaultPhase=LifecyclePhase.COMPILE, threadSafe=true)
public class GenerateModelMojo
extends AbstractKieMojo {
    public static final PathMatcher drlFileMatcher = FileSystems.getDefault().getPathMatcher("glob:**.drl");
    @Parameter(property="kogito.codegen.sources.directory", defaultValue="${project.build.directory}/generated-sources/kogito")
    private File customizableSourcesPath;
    @Parameter(property="kogito.codegen.partial", defaultValue="false")
    private boolean generatePartial;
    @Parameter(property="kogito.codegen.ondemand", defaultValue="false")
    private boolean onDemand;
    @Parameter(property="kogito.sources.keep", defaultValue="false")
    private boolean keepSources;

    public void execute() throws MojoExecutionException {
        this.addCompileSourceRoots();
        if (this.isOnDemand()) {
            this.getLog().info((CharSequence)"On-Demand Mode is On. Use mvn compile kogito:scaffold");
        } else {
            this.generateModel();
        }
    }

    protected boolean isOnDemand() {
        return this.onDemand;
    }

    @Override
    protected File getSourcesPath() {
        return this.customizableSourcesPath;
    }

    protected void addCompileSourceRoots() {
        this.project.addCompileSourceRoot(this.getSourcesPath().getPath());
        this.project.addCompileSourceRoot(this.generatedSources.getPath());
    }

    protected void generateModel() throws MojoExecutionException {
        this.setSystemProperties(this.properties);
        ApplicationGenerator appGen = ApplicationGeneratorDiscovery.discover((KogitoBuildContext)this.discoverKogitoRuntimeContext(this.projectClassLoader()));
        Collection generatedFiles = this.generatePartial ? appGen.generateComponents() : appGen.generate();
        this.writeGeneratedFiles(generatedFiles);
        if (!this.keepSources) {
            this.deleteDrlFiles();
        }
    }

    private void deleteDrlFiles() throws MojoExecutionException {
        try (Stream<Path> drlFiles = Files.find(this.outputDirectory.toPath(), Integer.MAX_VALUE, (p, f) -> drlFileMatcher.matches((Path)p), new FileVisitOption[0]);){
            drlFiles.forEach(p -> {
                try {
                    Files.delete(p);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to find .drl files");
        }
    }
}

