/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.kie.kogito.Model;
import org.kie.kogito.UserTask;
import org.kie.kogito.codegen.GeneratedFile;
import org.kie.kogito.codegen.GeneratedFileType;
import org.kie.kogito.codegen.JsonSchemaGenerator;
import org.kie.kogito.codegen.context.KogitoBuildContext;
import org.kie.kogito.codegen.process.persistence.PersistenceGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ProtoGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ReflectionProtoGenerator;
import org.kie.kogito.codegen.utils.GeneratedFileValidation;
import org.kie.kogito.maven.plugin.AbstractKieMojo;
import org.kie.kogito.process.ProcessInstancesFactory;
import org.kie.memorycompiler.CompilationResult;
import org.kie.memorycompiler.JavaCompiler;
import org.kie.memorycompiler.JavaCompilerFactory;
import org.kie.memorycompiler.JavaCompilerSettings;
import org.kie.memorycompiler.JavaConfiguration;
import org.kie.memorycompiler.resources.ResourceReader;
import org.kie.memorycompiler.resources.ResourceStore;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ConfigurationBuilder;

@Mojo(name="process-model-classes", requiresDependencyResolution=ResolutionScope.RUNTIME, requiresProject=true, defaultPhase=LifecyclePhase.PROCESS_CLASSES, threadSafe=true)
public class ProcessClassesMojo
extends AbstractKieMojo {
    private static final JavaCompiler JAVA_COMPILER = JavaCompilerFactory.loadCompiler((JavaConfiguration.CompilerType)JavaConfiguration.CompilerType.NATIVE, (String)"1.8");
    @Parameter(property="kogito.jsonSchema.version", required=false)
    private String schemaVersion;

    public void execute() throws MojoExecutionException {
        try {
            JavaCompilerSettings settings = new JavaCompilerSettings();
            ArrayList<URL> pathUrls = new ArrayList<URL>();
            for (String path : this.project.getRuntimeClasspathElements()) {
                pathUrls.add(new File(path).toURI().toURL());
                settings.addClasspath(path);
            }
            URL[] urlsForClassLoader = pathUrls.toArray(new URL[pathUrls.size()]);
            try (URLClassLoader cl = new URLClassLoader(urlsForClassLoader, Thread.currentThread().getContextClassLoader());){
                ConfigurationBuilder builder = new ConfigurationBuilder();
                builder.addUrls(cl.getURLs());
                builder.addClassLoader((ClassLoader)cl);
                Reflections reflections = new Reflections((Configuration)builder);
                Set modelClasses = reflections.getSubTypesOf(Model.class);
                Set classes = reflections.getSubTypesOf(ProcessInstancesFactory.class);
                Class persistenceClass = classes.isEmpty() ? null : (Class)classes.iterator().next();
                ReflectionProtoGenerator protoGenerator = (ReflectionProtoGenerator)ReflectionProtoGenerator.builder().withPersistenceClass((Object)persistenceClass).build((Collection)modelClasses);
                KogitoBuildContext context = this.discoverKogitoRuntimeContext(cl);
                PersistenceGenerator persistenceGenerator = new PersistenceGenerator(context, (ProtoGenerator)protoGenerator);
                Collection persistenceFiles = persistenceGenerator.generate();
                GeneratedFileValidation.validateGeneratedFileTypes((Collection)persistenceFiles, Arrays.asList(GeneratedFileType.Category.SOURCE, GeneratedFileType.Category.RESOURCE));
                Collection generatedClasses = persistenceFiles.stream().filter(x -> x.category().equals((Object)GeneratedFileType.Category.SOURCE)).collect(Collectors.toList());
                Collection generatedResources = persistenceFiles.stream().filter(x -> x.category().equals((Object)GeneratedFileType.Category.RESOURCE)).collect(Collectors.toList());
                this.compileAndWriteClasses(generatedClasses, cl, settings);
                generatedResources.forEach(this::writeGeneratedFile);
                Stream<Class<?>> classStream = reflections.getTypesAnnotatedWith(UserTask.class).stream();
                this.generateJsonSchema(classStream).forEach(this::writeGeneratedFile);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error during processing model classes", e);
        }
    }

    private void compileAndWriteClasses(Collection<GeneratedFile> generatedClasses, ClassLoader cl, JavaCompilerSettings settings) throws MojoFailureException {
        MemoryFileSystem srcMfs = new MemoryFileSystem();
        MemoryFileSystem trgMfs = new MemoryFileSystem();
        String[] sources = new String[generatedClasses.size()];
        int index = 0;
        for (GeneratedFile entry : generatedClasses) {
            String fileName = entry.relativePath();
            sources[index++] = fileName;
            srcMfs.write(fileName, entry.contents());
        }
        if (sources.length > 0) {
            CompilationResult result = JAVA_COMPILER.compile(sources, (ResourceReader)srcMfs, (ResourceStore)trgMfs, cl, settings);
            if (result.getErrors().length > 0) {
                throw new MojoFailureException(Arrays.toString(result.getErrors()));
            }
            for (String fileName : trgMfs.getFileNames()) {
                byte[] data = trgMfs.getBytes(fileName);
                this.writeGeneratedFile(new GeneratedFile(GeneratedFileType.COMPILED_CLASS, fileName, data));
            }
        }
    }

    private Collection<GeneratedFile> generateJsonSchema(Stream<Class<?>> classes) throws IOException {
        return new JsonSchemaGenerator.ClassBuilder(classes).withGenSchemaPredicate(x -> true).withSchemaVersion(this.schemaVersion).build().generate();
    }
}

