/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.maven.plugin;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.kie.kogito.codegen.api.GeneratedFile;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.context.impl.JavaKogitoBuildContext;
import org.kie.kogito.codegen.api.context.impl.QuarkusKogitoBuildContext;
import org.kie.kogito.codegen.api.context.impl.SpringBootKogitoBuildContext;
import org.kie.kogito.codegen.api.utils.AddonsConfigDiscovery;
import org.kie.kogito.codegen.api.utils.AppPaths;
import org.kie.kogito.codegen.core.utils.GeneratedFileWriter;
import org.kie.kogito.maven.plugin.util.MojoUtil;

public abstract class AbstractKieMojo
extends AbstractMojo {
    @Parameter(required=true, defaultValue="${project.basedir}")
    protected File projectDir;
    @Parameter
    protected Map<String, String> properties;
    @Parameter(required=true, defaultValue="${project}")
    protected MavenProject project;
    @Parameter(required=true, defaultValue="${project.build.outputDirectory}")
    protected File outputDirectory;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/kogito/")
    protected File generatedSources;
    @Parameter(defaultValue="${project.build.directory}/generated-resources/kogito/")
    protected File generatedResources;
    @Parameter(property="kogito.codegen.persistence", defaultValue="true")
    protected boolean persistence;
    @Parameter(property="kogito.codegen.rules", defaultValue="true")
    protected String generateRules;
    @Parameter(property="kogito.codegen.processes", defaultValue="true")
    protected String generateProcesses;
    @Parameter(property="kogito.codegen.decisions", defaultValue="true")
    protected String generateDecisions;
    @Parameter(property="kogito.codegen.predictions", defaultValue="true")
    protected String generatePredictions;

    protected void setSystemProperties(Map<String, String> properties) {
        if (properties != null) {
            this.getLog().debug((CharSequence)("Additional system properties: " + properties));
            for (Map.Entry<String, String> property : properties.entrySet()) {
                System.setProperty(property.getKey(), property.getValue());
            }
            this.getLog().debug((CharSequence)"Configured system properties were successfully set.");
        }
    }

    protected KogitoBuildContext discoverKogitoRuntimeContext(ClassLoader classLoader) {
        AppPaths appPaths = AppPaths.fromProjectDir((Path)this.projectDir.toPath());
        KogitoBuildContext context = this.contextBuilder().withClassAvailabilityResolver(this::hasClassOnClasspath).withApplicationProperties(appPaths.getResourceFiles()).withPackageName(this.appPackageName()).withAddonsConfig(AddonsConfigDiscovery.discover(this::hasClassOnClasspath)).withClassLoader(classLoader).withAppPaths(appPaths).build();
        this.additionalProperties(context);
        return context;
    }

    private void additionalProperties(KogitoBuildContext context) {
        context.setApplicationProperty("kogito.codegen.rules", (Object)this.generateRules);
        context.setApplicationProperty("kogito.codegen.processes", (Object)this.generateProcesses);
        context.setApplicationProperty("kogito.codegen.predictions", (Object)this.generatePredictions);
        context.setApplicationProperty("kogito.codegen.decisions", (Object)this.generateDecisions);
        context.setApplicationProperty("kogito.codegen.persistence", (Object)this.persistence);
    }

    protected ClassLoader projectClassLoader() throws MojoExecutionException {
        return MojoUtil.createProjectClassLoader(((Object)((Object)this)).getClass().getClassLoader(), this.project, this.outputDirectory, null);
    }

    protected String appPackageName() {
        return "org.kie.kogito.app";
    }

    private KogitoBuildContext.Builder contextBuilder() {
        switch (this.discoverFramework()) {
            case QUARKUS: {
                return QuarkusKogitoBuildContext.builder();
            }
            case SPRING: {
                return SpringBootKogitoBuildContext.builder();
            }
        }
        return JavaKogitoBuildContext.builder();
    }

    private Framework discoverFramework() {
        if (this.hasDependency("quarkus")) {
            return Framework.QUARKUS;
        }
        if (this.hasDependency("spring")) {
            return Framework.SPRING;
        }
        return Framework.NONE;
    }

    private boolean hasDependency(String dependency) {
        return this.project.getDependencies().stream().anyMatch(d -> d.getArtifactId().contains(dependency));
    }

    private boolean hasClassOnClasspath(String className) {
        try {
            Set elements = this.project.getArtifacts();
            URL[] urls = new URL[elements.size()];
            int i = 0;
            for (Artifact artifact : elements) {
                urls[i] = artifact.getFile().toURI().toURL();
                ++i;
            }
            try (URLClassLoader cl = new URLClassLoader(urls);){
                cl.loadClass(className);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected void writeGeneratedFiles(Collection<GeneratedFile> generatedFiles) {
        generatedFiles.forEach(this::writeGeneratedFile);
    }

    protected void writeGeneratedFile(GeneratedFile generatedFile) {
        GeneratedFileWriter writer = new GeneratedFileWriter(this.outputDirectory.toPath(), this.generatedSources.toPath(), this.generatedResources.toPath(), this.getSourcesPath().toPath());
        this.getLog().info((CharSequence)("Generating: " + generatedFile.relativePath()));
        writer.write(generatedFile);
    }

    protected File getSourcesPath() {
        return this.generatedSources;
    }

    private static enum Framework {
        QUARKUS,
        SPRING,
        NONE;

    }
}

