/*
 * Decompiled with CFR 0.152.
 */
package org.kogito.workitem.openapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kogito.workitem.openapi.JsonNodeParameterResolver;

class JsonNodeParameterResolverTest {
    final ObjectMapper mapper = new ObjectMapper();

    JsonNodeParameterResolverTest() {
    }

    @Test
    void verifyMultipleBranchesNode() throws JsonProcessingException {
        JsonNode inputModel = this.mapper.readTree("{ \"fahrenheit\": \"32\", \"subtractValue\": \"3\" }");
        String parameterDefinition = "{\n   \"SubtractionOperation\":{\n      \"leftElement\":\"$.fahrenheit\",\n      \"rightElement\":\"$.subtractValue\"\n   }\n}";
        JsonNodeParameterResolver resolver = new JsonNodeParameterResolver("{\n   \"SubtractionOperation\":{\n      \"leftElement\":\"$.fahrenheit\",\n      \"rightElement\":\"$.subtractValue\"\n   }\n}");
        JsonNode processedNode = resolver.apply((Object)inputModel);
        MatcherAssert.assertThat((Object)processedNode.get("SubtractionOperation").get("leftElement").asInt(), (Matcher)Matchers.is((Object)32));
        MatcherAssert.assertThat((Object)processedNode.get("SubtractionOperation").get("rightElement").asInt(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    void verifyArrayNode() throws JsonProcessingException {
        JsonNode inputModel = this.mapper.readTree("{ \"fahrenheit\": \"32\", \"subtractValue\": \"3\" }");
        String parameterDefinition = "[\n   {\n      \"leftElement\":\"$.fahrenheit\"\n   },\n   {\n      \"rightElement\":\"$.subtractValue\"\n   }\n]";
        JsonNodeParameterResolver resolver = new JsonNodeParameterResolver("[\n   {\n      \"leftElement\":\"$.fahrenheit\"\n   },\n   {\n      \"rightElement\":\"$.subtractValue\"\n   }\n]");
        JsonNode processedNode = resolver.apply((Object)inputModel);
        Assertions.assertTrue((boolean)processedNode.isArray());
        MatcherAssert.assertThat((Object)processedNode.findValue("leftElement").asInt(), (Matcher)Matchers.equalTo((Object)32));
        MatcherAssert.assertThat((Object)processedNode.findValue("rightElement").asInt(), (Matcher)Matchers.equalTo((Object)3));
    }

    @Test
    void verifyValueNode() throws JsonProcessingException {
        JsonNode inputModel = this.mapper.readTree("{ \"fahrenheit\": \"32\", \"subtractValue\": \"3\" }");
        String parameterDefinition = "\"$.fahrenheit\"";
        JsonNodeParameterResolver resolver = new JsonNodeParameterResolver("\"$.fahrenheit\"");
        JsonNode processedNode = resolver.apply((Object)inputModel);
        Assertions.assertTrue((boolean)processedNode.isValueNode());
        MatcherAssert.assertThat((Object)processedNode.asInt(), (Matcher)Matchers.equalTo((Object)32));
    }

    @Test
    void verifyArrayValueNode() throws JsonProcessingException {
        JsonNode inputModel = this.mapper.readTree("{ \"fahrenheit\": \"32\", \"subtractValue\": \"3\" }");
        String parameterDefinition = "[\"$.fahrenheit\", \"$.subtractValue\"]";
        JsonNodeParameterResolver resolver = new JsonNodeParameterResolver("[\"$.fahrenheit\", \"$.subtractValue\"]");
        JsonNode processedNode = resolver.apply((Object)inputModel);
        Assertions.assertTrue((boolean)processedNode.isArray());
        MatcherAssert.assertThat((Object)processedNode.get(0).asInt(), (Matcher)Matchers.equalTo((Object)32));
        MatcherAssert.assertThat((Object)processedNode.get(1).asInt(), (Matcher)Matchers.equalTo((Object)3));
    }

    @Test
    void verifyParameterAsJsonPath() throws JsonProcessingException {
        JsonNode inputModel = this.mapper.readTree("{ \"fahrenheit\": \"32\", \"subtractValue\": \"3\" }");
        String parameterDefinition = "$.fahrenheit";
        JsonNodeParameterResolver resolver = new JsonNodeParameterResolver("$.fahrenheit");
        JsonNode processedNode = resolver.apply((Object)inputModel);
        Assertions.assertTrue((boolean)processedNode.isValueNode());
        MatcherAssert.assertThat((Object)processedNode.asInt(), (Matcher)Matchers.equalTo((Object)32));
    }
}

