/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.pmml.openapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.smallrye.openapi.runtime.io.JsonUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.jupiter.api.Test;
import org.kie.kogito.pmml.openapi.PMMLOASUtils;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.FIELD_USAGE_TYPE;
import org.kie.pmml.api.models.Interval;
import org.kie.pmml.api.models.MiningField;

class PMMLOASUtilsTest {
    PMMLOASUtilsTest() {
    }

    @Test
    void isRequired() {
        MiningField toVerify = new MiningField(null, FIELD_USAGE_TYPE.PREDICTED, null, null, null, null, null, null, null, null);
        Assertions.assertThat((boolean)PMMLOASUtils.isRequired((MiningField)toVerify)).isFalse();
        toVerify = new MiningField(null, FIELD_USAGE_TYPE.TARGET, null, null, null, null, null, null, null, null);
        Assertions.assertThat((boolean)PMMLOASUtils.isRequired((MiningField)toVerify)).isFalse();
        toVerify = new MiningField(null, null, null, null, null, null, "MISSING_VALUE_REPLACEMENT", null, null, null);
        Assertions.assertThat((boolean)PMMLOASUtils.isRequired((MiningField)toVerify)).isFalse();
        toVerify = new MiningField(null, null, null, null, null, null, null, null, null, null);
        Assertions.assertThat((boolean)PMMLOASUtils.isRequired((MiningField)toVerify)).isTrue();
    }

    @Test
    void isPredicted() {
        MiningField toVerify = new MiningField(null, FIELD_USAGE_TYPE.PREDICTED, null, null, null, null, null, null, null, null);
        Assertions.assertThat((boolean)PMMLOASUtils.isPredicted((MiningField)toVerify)).isTrue();
        toVerify = new MiningField(null, FIELD_USAGE_TYPE.TARGET, null, null, null, null, null, null, null, null);
        Assertions.assertThat((boolean)PMMLOASUtils.isPredicted((MiningField)toVerify)).isTrue();
        toVerify = new MiningField(null, null, null, null, null, null, null, null, null, null);
        Assertions.assertThat((boolean)PMMLOASUtils.isPredicted((MiningField)toVerify)).isFalse();
        Arrays.stream(FIELD_USAGE_TYPE.values()).filter(usageType -> usageType != FIELD_USAGE_TYPE.TARGET && usageType != FIELD_USAGE_TYPE.PREDICTED).forEach(usageType -> {
            MiningField miningField = new MiningField(null, usageType, null, null, null, null, null, null, null, null);
            Assertions.assertThat((boolean)PMMLOASUtils.isPredicted((MiningField)miningField)).isFalse();
        });
    }

    @Test
    void getMappedType() {
        Arrays.stream(DATA_TYPE.values()).forEach(dataType -> {
            String expected;
            switch (dataType) {
                case DATE: 
                case DATE_TIME: 
                case STRING: {
                    expected = "string";
                    break;
                }
                case BOOLEAN: {
                    expected = "boolean";
                    break;
                }
                case INTEGER: {
                    expected = "integer";
                    break;
                }
                default: {
                    expected = "number";
                }
            }
            Assertions.assertThat((String)PMMLOASUtils.getMappedType((DATA_TYPE)dataType)).isEqualTo(expected);
        });
    }

    @Test
    void getMappedFormat() {
        Arrays.stream(DATA_TYPE.values()).forEach(dataType -> {
            String expected;
            switch (dataType) {
                case DOUBLE: {
                    expected = "double";
                    break;
                }
                case FLOAT: {
                    expected = "float";
                    break;
                }
                default: {
                    expected = null;
                }
            }
            Assertions.assertThat((String)PMMLOASUtils.getMappedFormat((DATA_TYPE)dataType)).isEqualTo(expected);
        });
    }

    @Test
    void addIntervals() {
        ObjectNode typeFieldNode = JsonUtil.objectNode();
        PMMLOASUtils.addIntervals((ObjectNode)typeFieldNode, Collections.emptyList());
        Assertions.assertThat((Iterable)typeFieldNode).isEmpty();
        Interval interval = new Interval((Number)-34.23, null);
        PMMLOASUtils.addIntervals((ObjectNode)typeFieldNode, Collections.singletonList(interval));
        Assertions.assertThat((Iterable)typeFieldNode.get("minimum")).isNotNull();
        NumericNode numericNode = (NumericNode)typeFieldNode.get("minimum");
        Assertions.assertThat((double)numericNode.asDouble()).isEqualTo(interval.getLeftMargin().doubleValue());
        Assertions.assertThat((Iterable)typeFieldNode.get("maximum")).isNull();
        Assertions.assertThat((Iterable)typeFieldNode.get("intervals")).isNull();
        typeFieldNode = JsonUtil.objectNode();
        interval = new Interval(null, (Number)35.0);
        PMMLOASUtils.addIntervals((ObjectNode)typeFieldNode, Collections.singletonList(interval));
        Assertions.assertThat((Iterable)typeFieldNode.get("minimum")).isNull();
        Assertions.assertThat((Iterable)typeFieldNode.get("maximum")).isNotNull();
        numericNode = (NumericNode)typeFieldNode.get("maximum");
        Assertions.assertThat((double)numericNode.asDouble()).isEqualTo(interval.getRightMargin().doubleValue());
        Assertions.assertThat((Iterable)typeFieldNode.get("intervals")).isNull();
        typeFieldNode = JsonUtil.objectNode();
        interval = new Interval((Number)-34.23, (Number)35.0);
        PMMLOASUtils.addIntervals((ObjectNode)typeFieldNode, Collections.singletonList(interval));
        Assertions.assertThat((Iterable)typeFieldNode.get("minimum")).isNotNull();
        numericNode = (NumericNode)typeFieldNode.get("minimum");
        Assertions.assertThat((double)numericNode.asDouble()).isEqualTo(interval.getLeftMargin().doubleValue());
        Assertions.assertThat((Iterable)typeFieldNode.get("maximum")).isNotNull();
        numericNode = (NumericNode)typeFieldNode.get("maximum");
        Assertions.assertThat((double)numericNode.asDouble()).isEqualTo(interval.getRightMargin().doubleValue());
        Assertions.assertThat((Iterable)typeFieldNode.get("intervals")).isNull();
        typeFieldNode = JsonUtil.objectNode();
        List intervals = IntStream.range(0, 3).mapToObj(i -> new Interval((Number)(i * 2 + 3), (Number)(i * 3 + 4))).collect(Collectors.toList());
        PMMLOASUtils.addIntervals((ObjectNode)typeFieldNode, intervals);
        Assertions.assertThat((Iterable)typeFieldNode.get("minimum")).isNull();
        Assertions.assertThat((Iterable)typeFieldNode.get("maximum")).isNull();
        Assertions.assertThat((Iterable)typeFieldNode.get("intervals")).isNotNull();
        ArrayNode intervalsNode = (ArrayNode)typeFieldNode.get("intervals");
        List nodeList = StreamSupport.stream(intervalsNode.spliterator(), false).collect(Collectors.toList());
        Assertions.assertThat(nodeList).allMatch(node -> node instanceof TextNode);
        Assertions.assertThat(intervals).allSatisfy(intervalValue -> {
            Object leftMargin = intervalValue.getLeftMargin() != null ? intervalValue.getLeftMargin().toString() : "-" + PMMLOASUtils.INFINITY_SYMBOL;
            String rightMargin = intervalValue.getRightMargin() != null ? intervalValue.getRightMargin().toString() : PMMLOASUtils.INFINITY_SYMBOL;
            String expected = String.format("%s %s", leftMargin, rightMargin);
            Assertions.assertThat((List)nodeList).anySatisfy(node -> expected.equals(node.asText()));
        });
    }

    @Test
    void addToSetNode() {
        String fieldName = "fieldName";
        DATA_TYPE dataType = DATA_TYPE.DOUBLE;
        ObjectNode setNode = PMMLOASUtils.createSetNode();
        ObjectNode propertiesNode = (ObjectNode)setNode.get("properties");
        Assertions.assertThat((Iterable)propertiesNode).isEmpty();
        PMMLOASUtils.addToSetNode((String)fieldName, (DATA_TYPE)dataType, Collections.emptyList(), (ObjectNode)setNode);
        Assertions.assertThat((Iterable)propertiesNode.get(fieldName)).isNotNull();
        ObjectNode fieldNameNode = (ObjectNode)propertiesNode.get(fieldName);
        Assertions.assertThat((Iterable)fieldNameNode.get("type")).isNotNull();
        Assertions.assertThat((String)fieldNameNode.get("type").asText()).isEqualTo("number");
        Assertions.assertThat((Iterable)fieldNameNode.get("format")).isNotNull();
        Assertions.assertThat((String)fieldNameNode.get("format").asText()).isEqualTo("double");
        Assertions.assertThat((Iterable)fieldNameNode.get("enum")).isNull();
        List allowedValues = IntStream.range(0, 3).mapToObj(it -> "VALUE" + it).collect(Collectors.toList());
        setNode = PMMLOASUtils.createSetNode();
        propertiesNode = (ObjectNode)setNode.get("properties");
        Assertions.assertThat((Iterable)propertiesNode).isEmpty();
        PMMLOASUtils.addToSetNode((String)fieldName, (DATA_TYPE)dataType, allowedValues, (ObjectNode)setNode);
        Assertions.assertThat((Iterable)propertiesNode.get(fieldName)).isNotNull();
        fieldNameNode = (ObjectNode)propertiesNode.get(fieldName);
        Assertions.assertThat((Iterable)fieldNameNode.get("type")).isNotNull();
        Assertions.assertThat((String)fieldNameNode.get("type").asText()).isEqualTo("number");
        Assertions.assertThat((Iterable)fieldNameNode.get("format")).isNotNull();
        Assertions.assertThat((String)fieldNameNode.get("format").asText()).isEqualTo("double");
        ArrayNode availableValuesNode = (ArrayNode)fieldNameNode.get("enum");
        Assertions.assertThat((Iterable)availableValuesNode).hasSameSizeAs(allowedValues);
        List nodeList = StreamSupport.stream(availableValuesNode.spliterator(), false).collect(Collectors.toList());
        Assertions.assertThat(nodeList).allMatch(node -> node instanceof TextNode);
        Assertions.assertThat(allowedValues).allSatisfy(allowedValue -> Assertions.assertThat((List)nodeList).anyMatch(availableValueNode -> availableValueNode.asText().equals(allowedValue)));
    }

    @Test
    void conditionallyCreateEnumNode() {
        ObjectNode parentNode = JsonUtil.objectNode();
        ArrayNode created = PMMLOASUtils.conditionallyCreateEnumNode((ObjectNode)parentNode);
        ((IterableAssert)Assertions.assertThat((Iterable)created).isNotNull()).isEmpty();
        JsonNode jsonNode = parentNode.get("enum");
        ((IterableAssert)Assertions.assertThat((Iterable)jsonNode).isNotNull()).isEqualTo((Object)created);
        ArrayNode notCreated = PMMLOASUtils.conditionallyCreateEnumNode((ObjectNode)parentNode);
        ((IterableAssert)Assertions.assertThat((Iterable)notCreated).isNotNull()).isEqualTo((Object)created);
    }

    @Test
    void createSetNodeInParent() {
        ObjectNode parentNode = JsonUtil.objectNode();
        String nodeToCreate = "nodeToCreate";
        ObjectNode retrieved = PMMLOASUtils.createSetNodeInParent((ObjectNode)parentNode, (String)nodeToCreate);
        this.commonValidateSetNode(retrieved);
        Assertions.assertThat((Iterable)parentNode.get(nodeToCreate)).isEqualTo((Object)retrieved);
    }

    @Test
    void createSetNode() {
        ObjectNode retrieved = PMMLOASUtils.createSetNode();
        this.commonValidateSetNode(retrieved);
    }

    @Test
    void getNumericNode() {
        Number number = 1;
        NumericNode retrieved = PMMLOASUtils.getNumericNode((Number)number);
        this.commonValidateNumericNode(retrieved, number);
        number = Float.valueOf(1.0f);
        retrieved = PMMLOASUtils.getNumericNode((Number)number);
        this.commonValidateNumericNode(retrieved, number);
        number = 0.34;
        retrieved = PMMLOASUtils.getNumericNode((Number)number);
        this.commonValidateNumericNode(retrieved, number);
        number = new BigInteger("34343734734834872362532352352");
        retrieved = PMMLOASUtils.getNumericNode((Number)number);
        this.commonValidateNumericNode(retrieved, number);
        number = Short.parseShort("1");
        retrieved = PMMLOASUtils.getNumericNode((Number)number);
        this.commonValidateNumericNode(retrieved, number);
        number = Long.parseLong("343437347348348");
        retrieved = PMMLOASUtils.getNumericNode((Number)number);
        this.commonValidateNumericNode(retrieved, number);
        number = new BigDecimal("343437347348348.2345345634634");
        retrieved = PMMLOASUtils.getNumericNode((Number)number);
        this.commonValidateNumericNode(retrieved, number);
    }

    private void commonValidateSetNode(ObjectNode toValidate) {
        Assertions.assertThat((Iterable)toValidate).isNotNull();
        JsonNode typeNode = toValidate.get("type");
        ((IterableAssert)Assertions.assertThat((Iterable)typeNode).isNotNull()).isInstanceOf(TextNode.class);
        Assertions.assertThat((String)((TextNode)typeNode).asText()).isEqualTo("object");
        JsonNode propertiesNode = toValidate.get("properties");
        ((IterableAssert)((IterableAssert)Assertions.assertThat((Iterable)propertiesNode).isNotNull()).isInstanceOf(ObjectNode.class)).isEmpty();
    }

    private void commonValidateNumericNode(NumericNode toValidate, Number number) {
        String className;
        switch (className = number.getClass().getSimpleName()) {
            case "Integer": {
                Assertions.assertThat((Iterable)toValidate).isInstanceOf(IntNode.class);
                Assertions.assertThat((int)((IntNode)toValidate).intValue()).isEqualTo((Object)number);
                break;
            }
            case "Float": {
                Assertions.assertThat((Iterable)toValidate).isInstanceOf(FloatNode.class);
                Assertions.assertThat((float)((FloatNode)toValidate).floatValue()).isEqualTo((Object)number);
                break;
            }
            case "Double": {
                Assertions.assertThat((Iterable)toValidate).isInstanceOf(DoubleNode.class);
                Assertions.assertThat((double)((DoubleNode)toValidate).doubleValue()).isEqualTo((Object)number);
                break;
            }
            case "BigInteger": {
                Assertions.assertThat((Iterable)toValidate).isInstanceOf(BigIntegerNode.class);
                Assertions.assertThat((BigInteger)((BigIntegerNode)toValidate).bigIntegerValue()).isEqualTo((Object)number);
                break;
            }
            case "Short": {
                Assertions.assertThat((Iterable)toValidate).isInstanceOf(ShortNode.class);
                Assertions.assertThat((short)((ShortNode)toValidate).shortValue()).isEqualTo((Object)number);
                break;
            }
            case "Long": {
                Assertions.assertThat((Iterable)toValidate).isInstanceOf(LongNode.class);
                Assertions.assertThat((long)((LongNode)toValidate).longValue()).isEqualTo((Object)number);
                break;
            }
            case "BigDecimal": {
                Assertions.assertThat((Iterable)toValidate).isInstanceOf(DecimalNode.class);
                Assertions.assertThat((BigDecimal)((DecimalNode)toValidate).decimalValue()).isEqualTo((Object)number);
                break;
            }
            default: {
                throw new IllegalArgumentException("Failed to find a NumericNode for " + number.getClass());
            }
        }
    }
}

