/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.pmml;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.modelcompiler.builder.KieBaseBuilder;
import org.kie.api.KieBase;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieRuntimeFactory;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.HasNestedModels;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.compiler.commons.factories.KiePMMLModelFactory;
import org.kie.pmml.evaluator.api.container.PMMLPackage;
import org.kie.pmml.evaluator.assembler.container.PMMLPackageImpl;
import org.kie.pmml.evaluator.assembler.rulemapping.PMMLRuleMapper;
import org.kie.pmml.evaluator.assembler.service.PMMLCompilerService;
import org.kie.pmml.evaluator.assembler.service.PMMLLoaderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieRuntimeFactoryBuilder {
    private static final Logger logger = LoggerFactory.getLogger(KieRuntimeFactoryBuilder.class);

    private KieRuntimeFactoryBuilder() {
    }

    public static Map<KieBase, KieRuntimeFactory> fromResources(Stream<Resource> resources) {
        return KieRuntimeFactoryBuilder.commonFromResources(resources, PMMLLoaderService::getKiePMMLModelsLoadedFromResource, KieRuntimeFactoryBuilder::createPopulatedKnowledgeBuilderImpl);
    }

    public static Map<KieBase, KieRuntimeFactory> fromResourcesWithInMemoryCompilation(Stream<Resource> resources) {
        return KieRuntimeFactoryBuilder.commonFromResources(resources, PMMLCompilerService::getKiePMMLModelsCompiledFromResource, KieRuntimeFactoryBuilder::createEmptyKnowledgeBuilderImpl);
    }

    private static Map<KieBase, KieRuntimeFactory> commonFromResources(Stream<Resource> resources, BiFunction<KnowledgeBuilderImpl, Resource, List<KiePMMLModel>> modelProducer, Function<Resource, KnowledgeBuilderImpl> kbuilderImplProvider) {
        HashMap<KieBase, KieRuntimeFactory> toReturn = new HashMap<KieBase, KieRuntimeFactory>();
        resources.forEach(resource -> {
            KnowledgeBuilderImpl kbuilderImpl = (KnowledgeBuilderImpl)kbuilderImplProvider.apply((Resource)resource);
            List toAdd = (List)modelProducer.apply(kbuilderImpl, (Resource)resource);
            if (toAdd.isEmpty()) {
                throw new KiePMMLException("Failed to retrieve compiled models");
            }
            KieRuntimeFactoryBuilder.addModels(kbuilderImpl, toAdd);
            InternalKnowledgeBase kieBase = kbuilderImpl.getKnowledgeBase();
            toReturn.put((KieBase)kieBase, KieRuntimeFactory.of((KieBase)kieBase));
        });
        return toReturn;
    }

    private static void addModels(KnowledgeBuilderImpl kbuilderImpl, List<KiePMMLModel> toAdd) {
        for (KiePMMLModel kiePMMLModel : toAdd) {
            PackageDescr pkgDescr = new PackageDescr(kiePMMLModel.getKModulePackageName());
            PackageRegistry pkgReg = kbuilderImpl.getOrCreatePackageRegistry(pkgDescr);
            InternalKnowledgePackage kpkgs = pkgReg.getPackage();
            PMMLPackage pmmlPkg = (PMMLPackage)kpkgs.getResourceTypePackages().computeIfAbsent(ResourceType.PMML, rtp -> new PMMLPackageImpl());
            pmmlPkg.addAll(Collections.singletonList(kiePMMLModel));
            if (!(kiePMMLModel instanceof HasNestedModels)) continue;
            KieRuntimeFactoryBuilder.addModels(kbuilderImpl, ((HasNestedModels)kiePMMLModel).getNestedModels());
        }
    }

    private static KnowledgeBuilderImpl createEmptyKnowledgeBuilderImpl(Resource resource) {
        KnowledgeBaseImpl defaultKnowledgeBase = new KnowledgeBaseImpl("PMML", null);
        return new KnowledgeBuilderImpl((InternalKnowledgeBase)defaultKnowledgeBase);
    }

    private static KnowledgeBuilderImpl createPopulatedKnowledgeBuilderImpl(Resource resource) {
        KnowledgeBuilderImpl toReturn = KieRuntimeFactoryBuilder.createEmptyKnowledgeBuilderImpl(resource);
        List<PMMLRuleMapper> pmmlRuleMappers = KieRuntimeFactoryBuilder.loadPMMLRuleMappers(toReturn, resource);
        if (!pmmlRuleMappers.isEmpty()) {
            List models = pmmlRuleMappers.stream().map(PMMLRuleMapper::getModel).collect(Collectors.toList());
            toReturn = new KnowledgeBuilderImpl(KieBaseBuilder.createKieBaseFromModel(models, (KieBaseOption[])new KieBaseOption[0]));
        }
        return toReturn;
    }

    private static List<PMMLRuleMapper> loadPMMLRuleMappers(KnowledgeBuilderImpl kbuilderImpl, Resource resource) {
        try {
            KiePMMLModelFactory kiePMMLModelFactory = PMMLLoaderService.loadKiePMMLModelFactory((KnowledgeBuilderImpl)kbuilderImpl, (Resource)resource);
            return PMMLLoaderService.getPMMLRuleMappers((KnowledgeBuilderImpl)kbuilderImpl, (KiePMMLModelFactory)kiePMMLModelFactory);
        }
        catch (Exception e) {
            throw new KiePMMLException("Failed to retrieve RuleMappers for " + resource.getSourcePath(), (Throwable)e);
        }
    }
}

