/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.pmml.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.api.pmml.ParameterInfo;
import org.kie.kogito.pmml.utils.PMMLUtils;

class PMMLUtilsTest {
    PMMLUtilsTest() {
    }

    @Test
    void getPMMLRequestData() {
        String modelName = "MODEL_NAME";
        Map<String, Object> parameters = this.getParameters();
        PMMLRequestData retrieved = PMMLUtils.getPMMLRequestData((String)"MODEL_NAME", parameters);
        Assertions.assertNotNull((Object)retrieved);
        Assertions.assertEquals((Object)"MODEL_NAME", (Object)retrieved.getModelName());
        Map parameterInfos = retrieved.getMappedRequestParams();
        Assertions.assertEquals((int)parameters.size(), (int)parameterInfos.size());
        parameters.forEach((key, value) -> {
            Assertions.assertTrue((boolean)parameterInfos.containsKey(key));
            ParameterInfo parameterInfo = (ParameterInfo)parameterInfos.get(key);
            Assertions.assertEquals((Object)value, (Object)parameterInfo.getValue());
            Assertions.assertEquals(value.getClass(), (Object)parameterInfo.getType());
        });
    }

    private Map<String, Object> getParameters() {
        HashMap<String, Object> toReturn = new HashMap<String, Object>();
        IntStream.range(0, 3).forEach(i -> toReturn.put("KEY_" + i, "VALUE_" + i));
        return toReturn;
    }
}

