/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.pmml;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.api.pmml.PMML4Result;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.api.pmml.ParameterInfo;
import org.kie.kogito.pmml.PmmlPredictionModel;
import org.kie.memorycompiler.KieMemoryCompiler;
import org.kie.pmml.api.models.MiningField;
import org.kie.pmml.api.models.OutputField;
import org.kie.pmml.api.models.PMMLModel;
import org.kie.pmml.api.runtime.PMMLListener;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.api.runtime.PMMLRuntimeContext;

class PmmlPredictionModelTest {
    private static final PMML4Result PMML_4_RESULT = new PMML4Result();
    private static final String FILE_NAME = "FILE_NAME";
    private static final String MODEL_NAME = "MODEL_NAME";
    private static final PMMLModel PMML_MODEL = new PMMLModelInternal("FILE_NAME", "MODEL_NAME");
    private static final PMMLRuntime PMML_RUNTIME = PmmlPredictionModelTest.getPMMLRuntime();
    private static PmmlPredictionModel pmmlPredictionModel;

    PmmlPredictionModelTest() {
    }

    @BeforeAll
    public static void setup() {
        pmmlPredictionModel = new PmmlPredictionModel(PMML_RUNTIME, FILE_NAME, MODEL_NAME);
        Assertions.assertNotNull((Object)pmmlPredictionModel);
    }

    @Test
    void newContext() {
        Map<String, Object> parameters = this.getParameters();
        PMMLRuntimeContext retrieved = pmmlPredictionModel.newContext(parameters);
        Assertions.assertNotNull((Object)retrieved);
        PMMLRequestData pmmlRequestData = retrieved.getRequestData();
        Assertions.assertNotNull((Object)retrieved);
        Assertions.assertEquals((Object)MODEL_NAME, (Object)pmmlRequestData.getModelName());
        Map parameterInfos = pmmlRequestData.getMappedRequestParams();
        Assertions.assertEquals((int)parameters.size(), (int)parameterInfos.size());
        parameters.forEach((key, value) -> {
            Assertions.assertTrue((boolean)parameterInfos.containsKey(key));
            ParameterInfo parameterInfo = (ParameterInfo)parameterInfos.get(key);
            Assertions.assertEquals((Object)value, (Object)parameterInfo.getValue());
            Assertions.assertEquals(value.getClass(), (Object)parameterInfo.getType());
        });
    }

    @Test
    void evaluateAll() {
        Map<String, Object> parameters = this.getParameters();
        PMMLRuntimeContext context = pmmlPredictionModel.newContext(parameters);
        Assertions.assertEquals((Object)PMML_4_RESULT, (Object)pmmlPredictionModel.evaluateAll(context));
    }

    @Test
    void getKiePMMLModel() {
        Assertions.assertEquals((Object)PMML_MODEL, (Object)pmmlPredictionModel.getPMMLModel());
    }

    private Map<String, Object> getParameters() {
        HashMap<String, Object> toReturn = new HashMap<String, Object>();
        IntStream.range(0, 3).forEach(i -> toReturn.put("KEY_" + i, "VALUE_" + i));
        return toReturn;
    }

    private static PMMLRuntime getPMMLRuntime() {
        KieMemoryCompiler.MemoryCompilerClassLoader memoryCompilerClassLoader = new KieMemoryCompiler.MemoryCompilerClassLoader(Thread.currentThread().getContextClassLoader());
        return new PMMLRuntime(){
            private final List<PMMLModel> models = Collections.singletonList(PMML_MODEL);
            private final Set<PMMLListener> pmmlListeners = new HashSet<PMMLListener>();

            public List<PMMLModel> getPMMLModels(PMMLRuntimeContext context) {
                return this.models;
            }

            public Optional<PMMLModel> getPMMLModel(String fileName, String modelName, PMMLRuntimeContext context) {
                return this.models.stream().filter(model -> model.getFileName().equals(fileName) && model.getName().equals(modelName)).findFirst();
            }

            public PMML4Result evaluate(String s, PMMLRuntimeContext pmmlContext) {
                return PMML_4_RESULT;
            }
        };
    }

    private static class PMMLModelInternal
    implements PMMLModel {
        private final String fileName;
        private final String name;
        private final List<MiningField> miningFields = Collections.emptyList();
        private final List<OutputField> outputFields = Collections.emptyList();

        public PMMLModelInternal(String fileName, String name) {
            this.fileName = fileName;
            this.name = name;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getName() {
            return this.name;
        }

        public List<MiningField> getMiningFields() {
            return this.miningFields;
        }

        public List<OutputField> getOutputFields() {
            return this.outputFields;
        }
    }
}

