/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.pmml;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.api.pmml.PMML4Result;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.api.pmml.ParameterInfo;
import org.kie.kogito.pmml.PmmlPredictionModel;
import org.kie.pmml.api.models.MiningField;
import org.kie.pmml.api.models.OutputField;
import org.kie.pmml.api.models.PMMLModel;
import org.kie.pmml.api.runtime.PMMLContext;
import org.kie.pmml.api.runtime.PMMLRuntime;

class PmmlPredictionModelTest {
    private static final PMML4Result PMML_4_RESULT = new PMML4Result();
    private static final String MODEL_NAME = "MODEL_NAME";
    private static final PMMLModel PMML_MODEL = new PMMLModelInternal("MODEL_NAME");
    private static final PMMLRuntime PMML_RUNTIME = PmmlPredictionModelTest.getPMMLRuntime();
    private static PmmlPredictionModel pmmlPredictionModel;

    PmmlPredictionModelTest() {
    }

    @BeforeAll
    public static void setup() {
        pmmlPredictionModel = new PmmlPredictionModel(PMML_RUNTIME, MODEL_NAME);
        Assertions.assertNotNull((Object)pmmlPredictionModel);
    }

    @Test
    void newContext() {
        Map<String, Object> parameters = this.getParameters();
        PMMLContext retrieved = pmmlPredictionModel.newContext(parameters);
        Assertions.assertNotNull((Object)retrieved);
        PMMLRequestData pmmlRequestData = retrieved.getRequestData();
        Assertions.assertNotNull((Object)retrieved);
        Assertions.assertEquals((Object)MODEL_NAME, (Object)pmmlRequestData.getModelName());
        Map parameterInfos = pmmlRequestData.getMappedRequestParams();
        Assertions.assertEquals((int)parameters.size(), (int)parameterInfos.size());
        parameters.forEach((key, value) -> {
            Assertions.assertTrue((boolean)parameterInfos.containsKey(key));
            ParameterInfo parameterInfo = (ParameterInfo)parameterInfos.get(key);
            Assertions.assertEquals((Object)value, (Object)parameterInfo.getValue());
            Assertions.assertEquals(value.getClass(), (Object)parameterInfo.getType());
        });
    }

    @Test
    void evaluateAll() {
        Map<String, Object> parameters = this.getParameters();
        PMMLContext context = pmmlPredictionModel.newContext(parameters);
        Assertions.assertEquals((Object)PMML_4_RESULT, (Object)pmmlPredictionModel.evaluateAll(context));
    }

    @Test
    void getKiePMMLModel() {
        Assertions.assertEquals((Object)PMML_MODEL, (Object)pmmlPredictionModel.getPMMLModel());
    }

    private Map<String, Object> getParameters() {
        HashMap<String, Object> toReturn = new HashMap<String, Object>();
        IntStream.range(0, 3).forEach(i -> toReturn.put("KEY_" + i, "VALUE_" + i));
        return toReturn;
    }

    private static PMMLRuntime getPMMLRuntime() {
        return new PMMLRuntime(){
            private final List<PMMLModel> models = Collections.singletonList(PmmlPredictionModelTest.access$000());

            public List<PMMLModel> getPMMLModels() {
                return this.models;
            }

            public Optional<PMMLModel> getPMMLModel(String s) {
                return this.models.stream().filter(model -> model.getName().equals(s)).findFirst();
            }

            public PMML4Result evaluate(String s, PMMLContext pmmlContext) {
                return PMML_4_RESULT;
            }
        };
    }

    static /* synthetic */ PMMLModel access$000() {
        return PMML_MODEL;
    }

    private static class PMMLModelInternal
    implements PMMLModel {
        private final String name;
        private final List<MiningField> miningFields = Collections.emptyList();
        private final List<OutputField> outputFields = Collections.emptyList();

        public PMMLModelInternal(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public List<MiningField> getMiningFields() {
            return this.miningFields;
        }

        public List<OutputField> getOutputFields() {
            return this.outputFields;
        }
    }
}

